package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;


/**
 * Created by valery.osheter on 19-Nov-15.
 */
public class AppInfo extends Attribute
{

  public String nameSpace = "";
  public String data = "";

  public AppInfo()
  {
    super(KMIP.Tag.ApplicationSpecificInformation);
  }

  public AppInfo(String nameSpace, String data)
  {
    this();
    this.nameSpace = nameSpace;
    this.data = data;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    nameSpace = converter.convert(KMIP.Tag.ApplicationNamespace, nameSpace);
    data = converter.convertOptional(KMIP.Tag.ApplicationData, data);
    converter.convertEnd(begin);
  }
}
