package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;

/**
 * Created by valery.osheter on 18-Nov-15.
 */
public class AlternativeName extends Attribute
{
  public String value = null;
  public int type;

  public AlternativeName()
  {
    super(KMIP.Tag.AlternativeName);
  }

  public AlternativeName(String value, int type)
  {
    this();
    this.value = value;
    this.type = type;
  }

  public void convert(KMIPConverter converter) throws KMIPConvertException
  {
    int begin = converter.convertBegin(KMIP.tagAttributeValue(KMIP.TagType.Structure));
    value = converter.convert(KMIP.Tag.AlternativeNameValue, value);
    type = converter.convert(KMIP.Tag.AlternativeNameType, type);
    converter.convertEnd(begin);
  }
}
