package com.unbound.provider.kmip;

/**
 * Created by valery.osheter on 18-Nov-15.
 */
public class KMIP
{
  private static int stdTag(int x, int y)
  {
    return 0x42000000 | (x << 8) | y;
  }
  private static int extTag(int x, int y)
  {
    return 0x54000000 | (x << 8) | y;
  }

  public static int tagAttributeValue(int y)
  {
    return stdTag(0x000b, y);
  }

  private static int tagStruct(int x)
  {
    return stdTag(x, TagType.Structure);
  }
  private static int tagInt(int x)
  {
    return stdTag(x, TagType.Integer);
  }
  private static int tagInt64(int x)
  {
    return stdTag(x, TagType.LongInteger);
  }
  private static int tagBigInt(int x)
  {
    return stdTag(x, TagType.BigInteger);
  }
  private static int tagEnum(int x)
  {
    return stdTag(x, TagType.Enumeration);
  }
  private static int tagBool(int x)
  {
    return stdTag(x, TagType.Boolean);
  }
  private static int tagText(int x)
  {
    return stdTag(x, TagType.TextString);
  }
  private static int tagBytes(int x)
  {
    return stdTag(x, TagType.ByteString);
  }
  private static int tagDateTime(int x)
  {
    return stdTag(x, TagType.DateTime);
  }
  private static int tagInterval(int x)
  {
    return stdTag(x, TagType.Interval);
  }

  private static int extTagInt(int x)
  {
    return extTag(x, TagType.Integer);
  }
  private static int extTagInt64(int x)
  {
    return extTag(x, TagType.LongInteger);
  }
  private static int extTagEnum(int x)
  {
    return extTag(x, TagType.Enumeration);
  }
  private static int extTagBool(int x)
  {
    return extTag(x, TagType.Boolean);
  }
  private static int extTagBytes(int x)
  {
    return extTag(x, TagType.ByteString);
  }
  private static int extTagText(int x)
  {
    return extTag(x, TagType.TextString);
  }
  private static int extTagBigInt(int x)
  {
    return extTag(x, TagType.BigInteger);
  }
  private static int extTagDateTime(int x)
  {
    return extTag(x, TagType.DateTime);
  }
  private static  int extTagStructure(int x)
  {
    return extTag(x, TagType.Structure);
  }

  public static class TagType
  {
    public static final int Structure = 0x01;
    public static final int Integer = 0x02;
    public static final int LongInteger = 0x03;
    public static final int BigInteger = 0x04;
    public static final int Enumeration = 0x05;
    public static final int Boolean = 0x06;
    public static final int TextString = 0x07;
    public static final int ByteString = 0x08;
    public static final int DateTime = 0x09;
    public static final int Interval = 0x0a;
  }

  public static class Tag
  {
    public static final int ActivationDate = tagDateTime(0x0001);
    public static final int ApplicationData = tagText(0x0002);
    public static final int ApplicationNamespace = tagText(0x0003);
    public static final int ApplicationSpecificInformation = tagStruct(0x0004);
    public static final int ArchiveDate = tagDateTime(0x0005);
    public static final int AsynchronousCorrelationValue = tagBytes(0x0006);
    public static final int AsynchronousIndicator = tagBool(0x0007);
    public static final int Attribute = tagStruct(0x0008);
    public static final int AttributeIndex = tagInt(0x0009);
    public static final int AttributeName = tagText(0x000a);
    //public static final int AttributeValue = stdKmipTag(0x000b, 0);
    public static final int Authentication = tagStruct(0x000c);
    public static final int BatchCount = tagInt(0x000d);
    public static final int BatchErrorContinuationOption = tagEnum(0x000e);
    public static final int BatchItem = tagStruct(0x000f);
    public static final int BatchOrderOption = tagBool(0x0010);
    public static final int BlockCipherMode = tagEnum(0x0011);
    public static final int CancellationResult = tagEnum(0x0012);
    public static final int Certificate = tagStruct(0x0013);
    public static final int CertificateIdentifier = tagStruct(0x0014);
    public static final int CertificateIssuer = tagStruct(0x0015);
    public static final int CertificateIssuerAlternativeName = tagText(0x0016);
    public static final int CertificateIssuerDistinguishedName = tagText(0x0017);
    public static final int CertificateRequest = tagBytes(0x0018);
    public static final int CertificateRequestType = tagEnum(0x0019);
    public static final int CertificateSubject = tagStruct(0x001a);
    public static final int CertificateSubjectAlternativeName = tagText(0x001b);
    public static final int CertificateSubjectDistinguishedName = tagText(0x001c);
    public static final int CertificateType = tagEnum(0x001d);
    public static final int CertificateValue = tagBytes(0x001e);
    public static final int CommonTemplateAttribute = tagStruct(0x001f);
    public static final int CompromiseDate = tagDateTime(0x0020);
    public static final int CompromiseOccurrenceDate = tagDateTime(0x0021);
    public static final int ContactInformation = tagText(0x0022);
    public static final int Credential = tagStruct(0x0023);
    public static final int CredentialType = tagEnum(0x0024);
    public static final int CredentialValue = tagStruct(0x0025);
    public static final int CriticalityIndicator = tagBool(0x0026);
    public static final int CRTCoefficient = tagBigInt(0x0027);
    public static final int CryptographicAlgorithm = tagEnum(0x0028);
    public static final int CryptographicDomainParameters = tagStruct(0x0029);
    public static final int CryptographicLength = tagInt(0x002a);
    public static final int CryptographicParameters = tagStruct(0x002b);
    public static final int CryptographicUsageMask = tagInt(0x002c);
    //public static final int TagCustomAttribute = stdKmipTag(0x002d, 0);
    public static final int D = tagBigInt(0x002e);
    public static final int DeactivationDate = tagDateTime(0x002f);
    public static final int DerivationData = tagBytes(0x0030);
    public static final int DerivationMethod = tagEnum(0x0031);
    public static final int DerivationParameters = tagStruct(0x0032);
    public static final int DestroyDate = tagDateTime(0x0033);
    public static final int Digest = tagStruct(0x0034);
    public static final int DigestValue = tagBytes(0x0035);
    public static final int EncryptionKeyInformation = tagStruct(0x0036);
    public static final int G = tagBigInt(0x0037);
    public static final int HashingAlgorithm = tagEnum(0x0038);
    public static final int InitialDate = tagDateTime(0x0039);
    public static final int InitializationVector = tagBytes(0x003a);
    public static final int Issuer = tagText(0x003b);
    public static final int IterationCount = tagInt(0x003c);
    public static final int IVCounterNonce = tagBytes(0x003d);
    public static final int J = tagBigInt(0x003e);
    public static final int Key = tagBytes(0x003f);
    public static final int KeyBlock = tagStruct(0x0040);
    public static final int KeyCompressionType = tagEnum(0x0041);
    public static final int KeyFormatType = tagEnum(0x0042);
    public static final int KeyMaterialStruct = tagStruct(0x0043);
    public static final int KeyMaterialBuf = tagBytes(0x0043);
    public static final int KeyPartIdentifier = tagInt(0x0044);
    public static final int KeyValueStruct = tagStruct(0x0045);
    public static final int KeyValueBuf = tagBytes(0x0045);
    public static final int KeyWrappingData = tagStruct(0x0046);
    public static final int KeyWrappingSpecification = tagStruct(0x0047);
    public static final int LastChangeDate = tagDateTime(0x0048);
    public static final int LeaseTime = tagInterval(0x0049);
    public static final int Link = tagStruct(0x004a);
    public static final int LinkType = tagEnum(0x004b);
    public static final int LinkedObjectIdentifier = tagText(0x004c);
    public static final int MacSignature = tagBytes(0x004d);
    public static final int MacSignatureKeyInformation = tagText(0x004e);
    public static final int MaximumItems = tagInt(0x004f);
    public static final int MaximumResponseSize = tagInt(0x0050);
    public static final int MessageExtension = tagStruct(0x0051);
    public static final int Modulus = tagBigInt(0x0052);
    public static final int Name = tagStruct(0x0053);
    public static final int NameType = tagEnum(0x0054);
    public static final int NameValue = tagText(0x0055);
    public static final int ObjectGroup = tagText(0x0056);
    public static final int ObjectType = tagEnum(0x0057);
    public static final int Offset = tagInterval(0x0058);
    public static final int OpaqueDataType = tagEnum(0x0059);
    public static final int OpaqueDataValue = tagBytes(0x005a);
    public static final int OpaqueObject = tagStruct(0x005b);
    public static final int Operation = tagEnum(0x005c);
    public static final int OperationPolicyName = tagText(0x005d);
    public static final int P = tagBigInt(0x005e);
    public static final int PaddingMethod = tagEnum(0x005f);
    public static final int PrimeExponentP = tagBigInt(0x0060);
    public static final int PrimeExponentQ = tagBigInt(0x0061);
    public static final int PrimeFieldSize = tagBigInt(0x0062);
    public static final int PrivateExponent = tagBigInt(0x0063);
    public static final int PrivateKey = tagStruct(0x0064);
    public static final int PrivateKeyTemplateAttribute = tagStruct(0x0065);
    public static final int PrivateKeyUniqueIdentifier = tagText(0x0066);
    public static final int ProcessStartDate = tagDateTime(0x0067);
    public static final int ProtectStopDate = tagDateTime(0x0068);
    public static final int ProtocolVersion = tagStruct(0x0069);
    public static final int ProtocolVersionMajor = tagInt(0x006a);
    public static final int ProtocolVersionMinor = tagInt(0x006b);
    public static final int PublicExponent = tagBigInt(0x006c);
    public static final int PublicKey = tagStruct(0x006d);
    public static final int PublicKeyTemplateAttribute = tagStruct(0x006e);
    public static final int PublicKeyUniqueIdentifier = tagText(0x006f);
    public static final int PutFunction = tagEnum(0x0070);
    public static final int Q = tagBigInt(0x0071);
    public static final int QString = tagBytes(0x0072);
    public static final int QLength = tagInt(0x0073);
    public static final int QueryFunction = tagEnum(0x0074);
    public static final int RecommendedCurve = tagEnum(0x0075);
    public static final int ReplacedUniqueIdentifier = tagText(0x0076);
    public static final int RequestHeader = tagStruct(0x0077);
    public static final int RequestMessage = tagStruct(0x0078);
    public static final int RequestPayload = tagStruct(0x0079);
    public static final int ResponseHeader = tagStruct(0x007a);
    public static final int ResponseMessage = tagStruct(0x007b);
    public static final int ResponsePayload = tagStruct(0x007c);
    public static final int ResultMessage = tagText(0x007d);
    public static final int ResultReason = tagEnum(0x007e);
    public static final int ResultStatus = tagEnum(0x007f);
    public static final int RevocationMessage = tagText(0x0080);
    public static final int RevocationReason = tagStruct(0x0081);
    public static final int RevocationReasonCode = tagEnum(0x0082);
    public static final int KeyRoleType = tagEnum(0x0083);
    public static final int Salt = tagBytes(0x0084);
    public static final int SecretData = tagStruct(0x0085);
    public static final int SecretDataType = tagEnum(0x0086);
    public static final int SerialNumber = tagText(0x0087);
    public static final int ServerInformation = tagStruct(0x0088);
    public static final int SplitKey = tagStruct(0x0089);
    public static final int SplitKeyMethod = tagEnum(0x008a);
    public static final int SplitKeyParts = tagInt(0x008b);
    public static final int SplitKeyThreshold = tagInt(0x008c);
    public static final int State = tagEnum(0x008d);
    public static final int StorageStatusMask = tagInt(0x008e);
    public static final int SymmetricKey = tagStruct(0x008f);
    public static final int Template = tagStruct(0x0090);
    public static final int TemplateAttribute = tagStruct(0x0091);
    public static final int TimeStamp = tagDateTime(0x0092);
    public static final int UniqueBatchItemID = tagBytes(0x0093);
    public static final int UniqueIdentifier = tagText(0x0094);
    public static final int UsageLimits = tagStruct(0x0095);
    public static final int UsageLimitsCount = tagInt64(0x0096);
    public static final int UsageLimitsTotal = tagInt64(0x0097);
    public static final int UsageLimitsUnit = tagEnum(0x0098);
    public static final int Username = tagText(0x0099);
    public static final int ValidityDate = tagDateTime(0x009a);
    public static final int ValidityIndicator = tagEnum(0x009b);
    public static final int VendorExtension = tagStruct(0x009c);
    public static final int VendorIdentification = tagText(0x009d);
    public static final int WrappingMethod = tagEnum(0x009e);
    public static final int X = tagBigInt(0x009f);
    public static final int Y = tagBigInt(0x00a0);

    public static final int Password = tagText(0x00a1);
    public static final int DeviceIdentifier = tagText(0x00a2);
    public static final int EncodingOption = tagEnum(0x00a3);
    public static final int ExtensionInformation = tagStruct(0x00a4);
    public static final int ExtensionName = tagText(0x00a5);
    public static final int ExtensionTag = tagInt(0x00a6);
    public static final int ExtensionType = tagInt(0x00a7);
    public static final int Fresh = tagBool(0x00a8);
    public static final int MachineIdentifier = tagText(0x00a9);
    public static final int MediaIdentifier = tagText(0x00aa);
    public static final int NetworkIdentifier = tagText(0x00ab);
    public static final int ObjectGroupMember = tagEnum(0x00ac);
    public static final int CertificateLength = tagInt(0x00ad);
    public static final int DigitalSignatureAlgorithm = tagEnum(0x00ae);
    public static final int CertificateSerialNumber = tagBytes(0x00af);
    public static final int DeviceSerialNumber = tagText(0x00b0);
    public static final int IssuerAlternativeName = tagBytes(0x00b1);
    public static final int IssuerDistinguishedName = tagBytes(0x00b2);
    public static final int SubjectAlternativeName = tagBytes(0x00b3);
    public static final int SubjectDistinguishedName = tagBytes(0x00b4);
    public static final int X509CertificateIdentifier = tagStruct(0x00b5);
    public static final int X509CertificateIssuer = tagStruct(0x00b6);
    public static final int X509CertificateSubject = tagStruct(0x00b7);
    public static final int KeyValueLocation = tagStruct(0x00b8);
    public static final int KeyValueLocationValue = tagText(0x00b9);
    public static final int KeyValueLocationType = tagEnum(0x00ba);
    public static final int OriginalCreationDate = tagDateTime(0x00bc);
    public static final int PGPKey = tagStruct(0x00bd);
    public static final int PGPKeyVersion = tagInt(0x00be);
    public static final int AlternativeName = tagStruct(0x00bf);
    public static final int AlternativeNameValue = tagText(0x00c0);
    public static final int AlternativeNameType = tagEnum(0x00c1);
    public static final int Data = tagBytes(0x00c2);
    public static final int SignatureData = tagBytes(0x00c3);
    public static final int DataLength = tagInt(0x00c4);
    public static final int RandomIV = tagBool(0x00c5);
    public static final int MACData = tagBytes(0x00c6);
    public static final int AttestationType = tagEnum(0x00c7);
    public static final int Nonce = tagStruct(0x00c8);
    public static final int NonceID = tagBytes(0x00c9);
    public static final int NonceValue = tagBytes(0x00ca);
    public static final int AttestationMeasurement = tagBytes(0x00cb);
    public static final int AttestationAssertion = tagBytes(0x00cc);
    public static final int IVLength = tagInt(0x00cd);
    public static final int TagLength = tagInt(0x00ce);
    public static final int FixedFieldLength = tagInt(0x00cf);
    public static final int CounterLength = tagInt(0x00d0);
    public static final int InitialCounterValue = tagInt(0x00d1);
    public static final int InvocationFieldLength = tagInt(0x00d2);
    public static final int AttestationCapableIndicator = tagBool(0x00d3);
    public static final int OffsetItems = tagInt(0x00d4);
    public static final int LocatedItems = tagInt(0x00d5);
    public static final int CorrelationValue = tagBytes(0x00d6);
    public static final int InitIndicator = tagBool(0x00d7);
    public static final int FinalIndicator = tagBool(0x00d8);

    public static final int RNGParameters = tagStruct(0x00D9);
    public static final int RNGAlgorithm = tagEnum(0x00DA);
    public static final int DRBGAlgorithm = tagEnum(0x00DB);
    public static final int FIPS186Variation = tagEnum(0x00DC);
    public static final int PredictionResistance = tagBool(0x00DD);
    public static final int RandomNumberGenerator = tagEnum(0x00DE);
    public static final int ValidationInformation = tagStruct(0x00DF);
    public static final int ValidationAuthorityType = tagEnum(0x00E0);
    public static final int ValidationAuthorityCountry = tagText(0x00E1);
    public static final int ValidationAuthorityURI = tagText(0x00E2);
    public static final int ValidationVersionMajor = tagInt(0x00E3);
    public static final int ValidationVersionMinor = tagInt(0x00E4);
    public static final int ValidationType = tagEnum(0x00E5);
    public static final int ValidationLevel = tagEnum(0x00E6);
    public static final int ValidationCertificateIdentifier = tagText(0x00E7);
    public static final int ValidationCertificateURI = tagText(0x00E8);
    public static final int ValidationVendorURI = tagText(0x00E9);
    public static final int ValidationProfile = tagText(0x00EA);
    public static final int ProfileInformation = tagStruct(0x00EB);
    public static final int ProfileName = tagEnum(0x00EC);
    public static final int ServerURI = tagText(0x00ED);
    public static final int ServerPort = tagInt(0x00EE);
    public static final int StreamingCapability = tagBool(0x00EF);
    public static final int AsynchronousCapability = tagBool(0x00F0);
    public static final int AttestationCapability = tagBool(0x00F1);
    public static final int UnwrapMode = tagEnum(0x00F2);
    public static final int DestroyAction = tagEnum(0x00F3);
    public static final int ShreddingAlgorithm = tagEnum(0x00F4);
    public static final int RNGMode = tagEnum(0x00F5);
    public static final int ClientRegistrationMethod = tagEnum(0x00F6);
    public static final int CapabilityInformation = tagStruct(0x00F7);
    public static final int KeyWrapType = tagEnum(0x00F8);
    public static final int BatchUndoCapability = tagBool(0x00F9);
    public static final int BatchContinueCapability = tagBool(0x00FA);
    public static final int PKCS12FriendlyName = tagText(0x00FB);
    public static final int Description = tagText(0x00FC);
    public static final int Comment = tagText(0x00FD);
    public static final int AuthenticatedEncryptionAdditionalData = tagBytes(0x00FE);
    public static final int AuthenticatedEncryptionTag = tagBytes(0x00FF);
    public static final int SaltLength = tagInt(0x0100);
    public static final int MaskGenerator = tagEnum(0x0101);
    public static final int MaskGeneratorHashingAlgorithm = tagEnum(0x0102);
    public static final int PSource = tagBytes(0x0103);
    public static final int TrailerField = tagInt(0x0104);
    public static final int ClientCorrelationValue = tagText(0x0105);
    public static final int ServerCorrelationValue = tagText(0x0106);
    public static final int DigestedData = tagBytes(0x0107);
    public static final int CertificateSubjectCN = tagText(0x0108);
    public static final int CertificateSubjectO = tagText(0x0109);
    public static final int CertificateSubjectOU = tagText(0x010A);
    public static final int CertificateSubjectEmail = tagText(0x010B);
    public static final int CertificateSubjectC = tagText(0x010C);
    public static final int CertificateSubjectST = tagText(0x010D);
    public static final int CertificateSubjectL = tagText(0x010E);
    public static final int CertificateSubjectUID = tagText(0x010F);
    public static final int CertificateSubjectSerialNumber = tagText(0x0110);
    public static final int CertificateSubjectTitle = tagText(0x0111);
    public static final int CertificateSubjectDC = tagText(0x0112);
    public static final int CertificateSubjectDNQualifier = tagText(0x0113);
    public static final int CertificateIssuerCN = tagText(0x0114);
    public static final int CertificateIssuerO = tagText(0x0115);
    public static final int CertificateIssuerOU = tagText(0x0116);
    public static final int CertificateIssuerEmail = tagText(0x0117);
    public static final int CertificateIssuerC = tagText(0x0118);
    public static final int CertificateIssuerST = tagText(0x0119);
    public static final int CertificateIssuerL = tagText(0x011A);
    public static final int CertificateIssuerUID = tagText(0x011B);
    public static final int CertificateIssuerSerialNumber = tagText(0x011C);
    public static final int CertificateIssuerTitle = tagText(0x011D);
    public static final int CertificateIssuerDC = tagText(0x011E);
    public static final int CertificateIssuerDNQualifier = tagText(0x011F);
    public static final int Sensitive = tagBool(0x0120);
    public static final int AlwaysSensitive = tagBool(0x0121);
    public static final int Extractable = tagBool(0x0122);
    public static final int NeverExtractable = tagBool(0x0123);
    public static final int ReplaceExisting = tagBool(0x0124);

    public static final int CKA_CLASS = extTagEnum(0x0000);
    public static final int CKA_TOKEN = extTagBool(0x0001);
    public static final int CKA_PRIVATE = extTagBool(0x0002);
    public static final int CKA_LABEL = extTagText(0x0003);
    public static final int CKA_APPLICATION = extTagText(0x0010);
    public static final int CKA_VALUE = extTagBytes(0x0011);
    public static final int CKA_CERTIFICATE_TYPE = extTagEnum(0x0080);
    public static final int CKA_ISSUER = extTagBytes(0x0081);
    public static final int CKA_SERIAL_NUMBER = extTagBytes(0x0082);
    public static final int CKA_CERTIFICATE_CATEGORY = extTagEnum(0x0087);
    public static final int CKA_URL = extTagText(0x0089);
    public static final int CKA_OBJECT_ID = extTagBytes(0x0012);
    public static final int CKA_CHECK_VALUE = extTagBytes(0x0090);
    public static final int CKA_KEY_GEN_MECHANISM = extTagEnum(0x0166);
    public static final int CKA_KEY_TYPE = extTagEnum(0x0100);
    public static final int CKA_SUBJECT = extTagBytes(0x0101);
    public static final int CKA_ID = extTagBytes(0x0102);
    public static final int CKA_SENSITIVE = extTagBool(0x0103);
    public static final int CKA_ENCRYPT = extTagBool(0x0104);
    public static final int CKA_DECRYPT = extTagBool(0x0105);
    public static final int CKA_WRAP = extTagBool(0x0106);
    public static final int CKA_UNWRAP = extTagBool(0x0107);
    public static final int CKA_SIGN = extTagBool(0x0108);
    public static final int CKA_SIGN_RECOVER = extTagBool(0x0109);
    public static final int CKA_VERIFY = extTagBool(0x010A);
    public static final int CKA_VERIFY_RECOVER = extTagBool(0x010B);
    public static final int CKA_DERIVE = extTagBool(0x010C);
    public static final int CKA_START_DATE = extTagDateTime(0x0110);
    public static final int CKA_END_DATE = extTagDateTime(0x0111);
    public static final int CKA_MODULUS = extTagBigInt(0x0120);
    public static final int CKA_MODULUS_BITS = extTagInt(0x0121);
    public static final int CKA_PUBLIC_EXPONENT = extTagBigInt(0x0122);
    public static final int CKA_PRIVATE_EXPONENT = extTagBigInt(0x0123);
    public static final int CKA_PRIME_1 = extTagBigInt(0x0124);
    public static final int CKA_PRIME_2 = extTagBigInt(0x0125);
    public static final int CKA_EXPONENT_1 = extTagBigInt(0x0126);
    public static final int CKA_EXPONENT_2 = extTagBigInt(0x0127);
    public static final int CKA_COEFFICIENT = extTagBigInt(0x0128);
    public static final int CKA_VALUE_LEN = extTagInt(0x0161);
    public static final int CKA_EXTRACTABLE = extTagBool(0x0162);
    public static final int CKA_LOCAL = extTagBool(0x0163);
    public static final int CKA_NEVER_EXTRACTABLE = extTagBool(0x0164);
    public static final int CKA_ALWAYS_SENSITIVE = extTagBool(0x0165);
    public static final int CKA_MODIFIABLE = extTagBool(0x0170);
    public static final int CKA_ALWAYS_AUTHENTICATE = extTagBool(0x0202);
    //public static final int CKA_ALLOWED_MECHANISMS=        extTagBytes(0x);
    public static final int CKA_EC_PARAMS = extTagBytes(0x0180);
    public static final int CKA_EC_POINT = extTagBytes(0x0181);
    public static final int CKA_MECHANISM_TYPE = extTagEnum(0x0500);
    public static final int CKA_TRUSTED = extTagBool(0x0086);
    public static final int CKA_WRAP_WITH_TRUSTED = extTagBool(0x0210);
    public static final int xID = extTagBool(0x0211);

    // Extensions 540000 - 54FFFF
    public static final int DyDYCKA_UID = extTagInt64(0x7201);
    public static final int DyDYCKA_PASS_EC_POINT = extTagBytes(0x7202);
    public static final int DyDYCKA_DATA_EC_POINT = extTagBytes(0x7203);
    public static final int DyDYCKA_ECDSA_ENC_PUB_KEY = extTagBigInt(0x7206);
    public static final int DyDYCKA_LIMA_PUB_KEY = extTagBytes(0x7207);
    public static final int DyDYCKA_EDDSA_PUB_KEY = extTagBytes(0x7208);
    public static final int DyDYCKA_ERASE_KEY_MATERIAL = extTagBool(0x7209);
    public static final int DyDYCKA_FIPS = extTagBool(0x720a);
    public static final int DyCKA_MPC_SIGN_PROTECTED = extTagBool(0x720b);
    public static final int DyCKA_INTEGRITY_SIGNATURE = extTagBytes(0x720c);
    public static final int DYCKA_OBJECT_GROUPS = extTagText(0x720f);

    public static final int DYCKA_ECDSA_BIP_LEVEL = extTagInt(0x7210);
    public static final int DYCKA_ECDSA_BIP_CHILD_NUMBER = extTagInt(0x7211);
    public static final int DYCKA_ECDSA_BIP_PARENT_FINGERPRINT = extTagBytes(0x7212);
    public static final int DYCKA_ECDSA_BIP_CPAR = extTagBytes(0x7213);
    public static final int DYCKA_ECDSA_BIP_PARENT_UID = extTagInt64(0x7214);
    public static final int DYCKA_ECDSA_BIP_HARDENED = extTagBool(0x7215);

    public static final int DYCKA_EDDSA_BIP_LEVEL = extTagInt(0x7230);
    public static final int DYCKA_EDDSA_BIP_CHILD_NUMBER = extTagInt(0x7231);
    public static final int DYCKA_EDDSA_BIP_CPAR = extTagBytes(0x7233);
    public static final int DYCKA_EDDSA_BIP_PARENT_UID = extTagInt64(0x7234);
    public static final int DYCKA_EDDSA_BIP_HARDENED = extTagBool(0x7235);

    public static final int DYCKA_DIGEST_SHA_1 = extTagBytes(0x7220);
    public static final int DYCKA_DIGEST_SHA256 = extTagBytes(0x7221);
    public static final int DYCKA_DIGEST_SHA384 = extTagBytes(0x7222);
    public static final int DYCKA_DIGEST_SHA512 = extTagBytes(0x7223);

    //public static final int DYCKA_KEY_ROTATION_INTERVAL= extTagInt(0x7230);
    //public static final int DYCKA_NEXT_KEY_ROTATION_TIME = extTagInt64(0x7231);


    public static final int DyAuth = extTagBytes(0xff01);
    public static final int DyMgfAlg = extTagEnum(0xff02);
    public static final int DyPssSaltSize = extTagInt(0xff03);
    public static final int DySecretSize = extTagInt(0xff04);
    public static final int DyPartitionName = extTagText(0xff05);
    public static final int DyPartitionId = extTagText(0xff06);
    public static final int DyServer = extTagText(0xff07);
    public static final int DyLIMAKeyType = extTagEnum(0xff08);
    public static final int DyLIMAPrivateKey = extTagBytes(0xff09);
    public static final int DyLIMAPublicKey = extTagBytes(0xff0a);
    public static final int DyPaillierKey = extTagBytes(0xff0b);
    public static final int DyDetails = extTagBytes(0xff10);
    public static final int DyAuthType = extTagEnum(0xff11);
    public static final int DyRole = extTagText(0xff12);
    public static final int DyMode = extTagEnum(0xff13);
    public static final int DyActivationCode = extTagText(0xff14);
    public static final int DyCertificateRequest = extTagBytes(0xff15);
    public static final int DyPfxPassword = extTagText(0xff16);
    public static final int DyPFX = extTagBytes(0xff17);
    public static final int DyCertificate = extTagBytes(0xff18);
    public static final int DyObject = extTagText(0xff19);
    public static final int DyPublicKey = extTagBytes(0xff1a);
    public static final int DySecret = extTagText(0x1004);
    public static final int DyOperation = extTagBool(0x1005);
    public static final int DyOperations = extTagInt(0x1006);
    //public static final int DyObjectType = extTagBool(0x1006);
//        public static final int DyCryptographicAlgorithm = extTagBool(0x1007);
    public static final int DyPrivateOperation = extTagBool(0x1008);
    public static final int DyEp = extTagText(0xff20);
    public static final int DyPartner = extTagText(0xff21);
    public static final int DyAuxiliary = extTagText(0xff22);

    public static final int DyEpPublic = extTagText(0xff23);
    public static final int DyPartnerPublic = extTagText(0xff24);
    public static final int DyAuxiliaryPublic = extTagText(0xff25);

    public static final int DyEpCertificateThumbPrint = extTagText(0xff26);
    public static final int DyPartnerCertificateThumbPrint = extTagText(0xff27);
    public static final int DyAuxiliaryCertificateThumbPrint = extTagText(0xff28);
    public static final int DyForce = extTagText(0xff29);

    public static final int DyTopology = extTagText(0xff40);
    public static final int DyStatus = extTagText(0xff41);
    public static final int DyFull = extTagBool(0xff42);
    public static final int DyPassword = extTagText(0xff43);
    public static final int DyPartition = extTagText(0xff44);
    public static final int DyPresent = extTagBool(0xff45);
    public static final int DyPairOnly = extTagBool(0xff46);
    public static final int DyTitle = extTagText(0xff47);
    public static final int DySoUser = extTagText(0xff48);


    public static final int DyEpCertificate = extTagBytes(0xff30);
    public static final int DyPartnerCertificate = extTagBytes(0xff31);
    public static final int DyAuxiliaryCertificate = extTagBytes(0xff32);
    public static final int DyGetAllCAs = extTagBool(0xff33);

    public static final int DyExportable = extTagInt(0xff40);
    public static final int DyWrapable = extTagBytes(0xff41);
    public static final int DyWrapableWithTrusted = extTagBytes(0xff42);
    public static final int DyNonExportable = extTagBool(0xff43);

    public static final int DyClient = extTagText(0xff52);
    public static final int DyServerName = extTagText(0xff53);
    public static final int DyRetries = extTagInt(0xff54);
    public static final int DyGenerateAttestation = extTagBool(0xff55);
    public static final int DyCaCertificate = extTagBytes(0xff56);
    public static final int DyOperationsGroup = extTagBytes(0xff57);

    public static final int DyTemplate = extTagText(0xff58);

    public static final int DyGenericKey = extTagText(0xff59);
    public static final int DyBackup = extTagText(0xff70);

    public static final int DyChain = extTagText(0xfe5a);
    public static final int DyObjectGroup = extTagText(0xfe5b);
    public static final int DyIsPrimaryObject = extTagBool(0xfe5c);

    public static final int DyCreatedUsingDerive = extTagBool(0xfe5d);
    public static final int DyIsSync = extTagBool(0xfe5e);


    public static final int DyDateCreated = extTagText(0xff60);
    public static final int DyLastUpdated = extTagText(0xff61);
    public static final int DyLastPasswordUpdated = extTagText(0xff62);

    public static final int DyClientRegistrainRetries = extTagInt(0xff80);
    public static final int DyClientRegistrationTimeout = extTagInt(0xff81);
    public static final int DyUserLoginRetries = extTagInt(0xff82);
    public static final int DySamlTimeout = extTagInt(0xff83);
    public static final int DySamlCertificate = extTagBytes(0xff84);

    public static final int DyPasswordComplexity = extTagBool(0xff85);
    public static final int DyPasswordLength = extTagBytes(0xff86);
    public static final int DyCheckClientIp = extTagBool(0xff87);

    public static final int DyPartitionInheritance = extTagBool(0xff88);
    public static final int DyCertificatePropagation = extTagBool(0xff89);
    public static final int DyPartitionFipsRequirements = extTagEnum(0xff90);

    // used in Register command for auto activating the object after registration
    // added for implementing quorum on register as a single command instead of register/activate as two commands
    public static final int DyDoActivate = extTagBool(0xff8a);
    public static final int DyKeyOnly = extTagBool(0xff8b);
    public static final int DyTestMode = extTagBool(0xff8c);
    public static final int DyDeleteCertificate = extTagBool(0xff8d);
    public static final int DyJwtTimeout = extTagInt(0xff8e);
    public static final int DyJwtLimit = extTagInt(0xff5C);
    public static final int DyRoleObjectPermission = extTagStructure(0xff8f);

    // Global
    public static final int DyRefreshInterval = extTagInt(0xff90);
    public static final int DySyncInterval = extTagInt(0xff91);
    public static final int DyCheckAllowServers = extTagInt(0xff92);
    public static final int DyAllowNoCertificate = extTagBool(0xff93);
    public static final int DyAllowDefaultClient = extTagBool(0xff94);
    public static final int DySeedInterval = extTagInt(0xff95);
    public static final int DyLicense = extTagInt(0xff96);
    public static final int DyVersion = extTagText(0xff97);
    public static final int DyAllowNat = extTagBool(0xff98);

    public static final int DyRootCaCertificateExpiration = extTagInt(0xff99);
    public static final int DyServerCertificateExpiration = extTagInt(0xff9a);
    public static final int DyClientCertificateExpiration = extTagInt(0xff9b);

    public static final int DyRootCaCertificatePreExpiry = extTagInt(0xff9c);
    public static final int DyServerCertificatePreExpiry = extTagInt(0xff9d);
    public static final int DyClientCertificatePreExpiry = extTagInt(0xff9e);

    public static final int DyActivationCodeLength = extTagInt(0xff9f);
    public static final int DyExpiration = extTagText(0xff5a);
    public static final int DyClientCertExpiring = extTagBool(0xff5b);

    public static final int DyIpRange = extTagText(0xffc0);
    public static final int DyEnforceUniqueName = extTagBool(0xffc1);
    public static final int DyEnforceUniqueDescription = extTagBool(0xffc2);

    public static final int DyOfflineBackupKey = extTagBytes(0xffc3);
    public static final int DyGrantType = extTagInt(0xffc4);
    public static final int DyClientSecretExpiration = extTagInt(0xffc5);

    public static final int DyJwtExpiresAt = extTagText(0xffc6);
    public static final int DyJwtExpiresIn = extTagInt(0xffc7);

    public static final int DyRefreshJwt = extTagInt(0xffc8);
    public static final int DyLastActivity = extTagText(0xffc9);
    public static final int DyLastLogout = extTagText(0xffca);

    //Quorum
    public static final int DyQuorumValue = extTagText(0xffa0);
    public static final int DyQuorumInitiator = extTagText(0xffa1);
    public static final int DyQuorumIsApproved = extTagBool(0xffa2);
    public static final int DyQuorumApprover = extTagText(0xffa3);
    public static final int DyQuorumDate = extTagInt64(0xffa4);
    public static final int DyQuorumOperations = extTagText(0xffa5);
    public static final int DyQuorumTimeout = extTagInt(0xffa6);


    public static final int DyAllowOnlyCrypto = extTagBool(0xffb0);
    public static final int DyLdapProviderUrl = extTagText(0xffb1);
    public static final int DyLdapBindDn = extTagText(0xffb2);
    public static final int DyLdapBindDnPwd = extTagText(0xffb3);
    public static final int DyLdapCaCert = extTagBytes(0xffb4);
    public static final int DyLdapSearchFilter = extTagText(0xffb5);
    public static final int DyLdapDoNotVerifyCert = extTagBool(0xffb7);
    public static final int DyKeyRotationExecTime = extTagText(0xffb8);
    public static final int DyLdapSearchBase = extTagText(0xffb9);
    public static final int DySignAttributes = extTagBool(0xffe0);
    public static final int DyFips = extTagBool(0xffe1);
    public static final int DyKeyRotationInterval = extTagInt(0xffe2);
    public static final int DyNextKeyRotationTime = extTagInt64(0xffe3);
    //public static final int DyFullyDistributedObject = extTagBool(0xffb6);

    public static final int DyConnectTimeout = extTagInt(0xffd0);
    public static final int DyReadTimeout = extTagInt(0xffd1);
    public static final int DyWriteTimeout = extTagInt(0xffd2);

    public static final int DyCipherSuite = extTagText(0xffd3);

    public static final int DyKeepAliveIdle = extTagInt(0xffd4);
    public static final int DyKeepAliveInterval = extTagInt(0xffd5);
    public static final int DyKeepAliveCount = extTagInt(0xffd6);
    public static final int DyJws = extTagBytes(0xffd7);
    public static final int DyDateFrom = extTagDateTime(0xffd8);
    public static final int DyDateTo = extTagDateTime(0xffd9);
    public static final int DyPeriod = extTagEnum(0xffda);

    public static final int DyDseVersion = extTagText(0xffdb);
    public static final int DyDseKeyNamespace = extTagText(0xffdc);
    public static final int DyCheckJwtOriginator = extTagText(0xffdd);
  }

  public static class ErrorOption
  {
    public static final int Continue = 1;
    public static final int Stop = 2;
    public static final int Undo = 3;
  }

  public static class AttestationType
  {
    public static final int Quote = 0x00000001;
    public static final int TCGIntegrityReport = 0x00000002;
    public static final int SAMLAssertion = 0x00000003;
    public static final int DyJwtAssertion = 0x80000001;
  }

  public static class RevocationReason
  {
    public static final int Unspecified = 1;
    public static final int KeyCompromise = 2;
    public static final int CACompromise = 3;
    public static final int AffiliationChanged = 4;
    public static final int Superseded = 5;
    public static final int CessationOfOperation = 6;
    public static final int PrivilegeWithdrawn = 7;
  }

  public static class CredentialType
  {
    public static final int UsernameAndPassword = 1;
    public static final int Device = 2;
    public static final int Attestation = 3;
  }

  public static class KeyCompressionType
  {
    public static final int ECPublicKeyTypeUncompressed = 1;
    public static final int ECPublicKeyTypeX9_62CompressedPrime = 2;
    public static final int ECPublicKeyTypeX9_62CompressedChar2 = 3;
    public static final int ECPublicKeyTypeX9_62Hybrid = 4;
  }

  public static class KeyFormatType
  {
    public static final int Raw = 0x01;
    public static final int Opaque = 0x02;
    public static final int PKCS_1 = 0x03;
    public static final int PKCS_8 = 0x04;
    public static final int X_509 = 0x05;
    public static final int ECPrivateKey = 0x06;
    public static final int TransparentSymmetricKey = 0x07;
    public static final int TransparentDSAPrivateKey = 0x08;
    public static final int TransparentDSAPublicKey = 0x09;
    public static final int TransparentRSAPrivateKey = 0x0a;
    public static final int TransparentRSAPublicKey = 0x0b;
    public static final int TransparentDHPrivateKey = 0x0c;
    public static final int TransparentDHPublicKey = 0x0d;
    public static final int TransparentECDSAPrivateKey = 0x0e;
    public static final int TransparentECDSAPublicKey = 0x0f;
    public static final int TransparentECDHPrivateKey = 0x10;
    public static final int TransparentECDHPublicKey = 0x11;
    public static final int TransparentECMQVPrivateKey = 0x12;
    public static final int TransparentECMQVPublicKey = 0x13;
    public static final int TransparentECPrivateKey = 0x14;
    public static final int TransparentECPublicKey = 0x15;
    public static final int PKCS_12 = 0x16;
    public static final int TransparentLIMAPrivateKey = 0x80000001;
    public static final int PUBLIC_PEM = 0x80000002;
    public static final int PFX = 0x80000003;
    public static final int OBFUSCATED_PEM = 0x80000004;
    public static final int NOTARY = 0x80000005;
    public static final int PRIVATE_PEM = 0x80000006;
  }

  public static class WrappingMethod
  {
    public static final int Encrypt = 0x01;
    public static final int MACsign = 0x02;
    public static final int EncryptthenMACsign = 0x03;
    public static final int MACsignthenencrypt = 0x04;
    public static final int TR_31 = 0x05;
  }

  /* recommended curve enumeration for ecdsa; ecdh; and ecmqv */
  public static class RecommendedCurve
  {
    public static final int P_192 = 0x01;
    public static final int K_163 = 0x02;
    public static final int B_163 = 0x03;
    public static final int P_224 = 0x04;
    public static final int K_233 = 0x05;
    public static final int B_233 = 0x06;
    public static final int P_256 = 0x07;
    public static final int K_283 = 0x08;
    public static final int B_283 = 0x09;
    public static final int P_384 = 0x0a;
    public static final int K_409 = 0x0b;
    public static final int B_409 = 0x0c;
    public static final int P_521 = 0x0d;
    public static final int K_571 = 0x0e;
    public static final int B_571 = 0x0f;
    public static final int SECP256K1 = 0x00000019;
  }

  public static class CertificateType
  {
    public static final int None = 0;
    public static final int X_509 = 0x01;
  }

  public static class DigitalSignatureAlgorithm
  {
    public static final int Md2WithRSAEncryption = 1;
    public static final int Md5WithRSAEncryption = 2;
    public static final int SHA_1WithRSAEncryption = 3;
    public static final int SHA_224WithRSAEncryption = 4;
    public static final int SHA_256WithRSAEncryption = 5;
    public static final int SHA_384WithRSAEncryption = 6;
    public static final int SHA_512WithRSAEncryption = 7;
    public static final int RSASSA_PSS = 8;
    public static final int DSAWithSHA_1 = 9;
    public static final int DSAWithSHA224 = 10;
    public static final int DSAWithSHA256 = 11;
    public static final int ECDSAWithSHA_1 = 12;
    public static final int ECDSAWithSHA224 = 13;
    public static final int ECDSAWithSHA256 = 14;
    public static final int ECDSAWithSHA384 = 15;
    public static final int ECDSAWithSHA512 = 16;
  }

  public static class SecretDataType
  {
    public static final int Password = 1;
    public static final int Seed = 2;
  }

  public static class NameType
  {
    public static final int UninterpretedTextString = 1;
    public static final int Uri = 2;
  }

  public static class ObjectType
  {
    public static final int None = 0;
    public static final int Certificate = 0x01;
    public static final int SymmetricKey = 0x02;
    public static final int PublicKey = 0x03;
    public static final int PrivateKey = 0x04;
    public static final int SplitKey = 0x05;
    public static final int Template = 0x06;
    public static final int SecretData = 0x07;
    public static final int OpaqueObject = 0x08;
    public static final int PGPKey = 0x09;

    public static final int DyPartition = 0x80000001;
    public static final int DyClient = 0x80000002;
    public static final int DyPartitionUser = 0x80000003;
    public static final int DyRole = 0x80000004;
    public static final int DyGenericKey = 0x80000005;
  }

  public static class DyObjectGroup
  {
    public static final int Crypto = 0x8000000a;
    public static final int SecretData = 0x8000000c;
    public static final int PublicData = 0x8000000d;
  }

  public static class CryptographicAlgorithm
  {
    public static final int DES = 0x01;
    public static final int DES3 = 0x02;
    public static final int AES = 0x03;
    public static final int RSA = 0x04;
    public static final int DSA = 0x05;
    public static final int ECDSA = 0x06;
    public static final int HMAC_SHA1 = 0x07;
    public static final int HMAC_SHA224 = 0x08;
    public static final int HMAC_SHA256 = 0x09;
    public static final int HMAC_SHA384 = 0x0a;
    public static final int HMAC_SHA512 = 0x0b;
    public static final int HMAC_MD5 = 0x0c;
    public static final int DH = 0x0d;
    public static final int ECDH = 0x0e;
    public static final int ECMQV = 0x0f;
    public static final int Blowfish = 0x10;
    public static final int Camellia = 0x11;
    public static final int Cast5 = 0x12;
    public static final int Idea = 0x13;
    public static final int Mars = 0x14;
    public static final int RC2 = 0x15;
    public static final int RC4 = 0x16;
    public static final int RC5 = 0x17;
    public static final int Skipjack = 0x18;
    public static final int Twofish = 0x19;
    public static final int EC = 0x1a;

    public static final int DyPRF = 0x80000001;
    public static final int DyPWD = 0x80000002;
    public static final int DyAES_SIV = 0x80000003;
    public static final int DyAES_XTS = 0x80000004;
    public static final int DyLIMA = 0x80000005;
    public static final int DyECDSAEnc = 0x80000006;
    public static final int DyDeriveConcat = 0x80000007;
    public static final int DyEDDSA = 0x80000008;
    public static final int DyPrfCMacCtr = 0x80000009;
    public static final int DySchnorr = 0x8000000a;
  }

  public static class BlockCipherMode
  {
    public static final int CBC = 1;
    public static final int ECB = 2;
    public static final int PCBC = 3;
    public static final int CFB = 4;
    public static final int OFB = 5;
    public static final int CTR = 6;
    public static final int CMAC = 7;
    public static final int CCM = 8;
    public static final int GCM = 9;
    public static final int CBCMAC = 10;
    public static final int XTS = 11;
    public static final int AESKeyWrappadding = 12;
    public static final int NISTKeyWrap = 13;
    public static final int SIV = 0x80000001;
    public static final int GMAC = 0x80000002;
  }

  public static class PaddingMethod
  {
    public static final int None = 1;
    public static final int OAEP = 2;
    public static final int PKCS5 = 3;
    public static final int SSL3 = 4;
    public static final int Zeros = 5;
    public static final int ANSIX9_23 = 6;
    public static final int ISO = 7;
    public static final int PKCS1_V1_5 = 8;
    public static final int X9_31 = 9;
    public static final int PSS = 10;

    public static final int DyPrefix = 0x80000001;
    public static final int DySuffix = 0x80000002;
  }

  public static class HashingAlgorithm
  {
    public static final int MD2 = 1;
    public static final int MD4 = 2;
    public static final int MD5 = 3;
    public static final int SHA_1 = 4;
    public static final int SHA_224 = 5;
    public static final int SHA_256 = 6;
    public static final int SHA_384 = 7;
    public static final int SHA_512 = 8;
    public static final int RIPEMD_160 = 9;
    public static final int TIGER = 10;
    public static final int WHIRLPOOL = 11;
  }

  public static class KeyRoleType
  {
    public static final int BDK = 0x00000001;
    public static final int CVK = 0x00000002;
    public static final int DEK = 0x00000003;
    public static final int MKAC = 0x00000004;
    public static final int MKSMC = 0x00000005;
    public static final int MKSMI = 0x00000006;
    public static final int MKDAC = 0x00000007;
    public static final int MKDN = 0x00000008;
    public static final int MKCP = 0x00000009;
    public static final int MKOTH = 0x0000000A;
    public static final int KEK = 0x0000000B;
    public static final int MAC16609 = 0x0000000C;
    public static final int MAC97971 = 0x0000000D;
    public static final int MAC97972 = 0x0000000E;
    public static final int MAC97973 = 0x0000000F;
    public static final int MAC97974 = 0x00000010;
    public static final int MAC97975 = 0x00000011;
    public static final int ZPK = 0x00000012;
    public static final int PVKIBM = 0x00000013;
    public static final int PVKPVV = 0x00000014;
    public static final int PVKOTH = 0x00000015;
    public static final int DUKPT = 0x00000016;
    public static final int IV = 0x00000017;
    public static final int TRKBK = 0x00000018;
  }

  public static class State
  {
    public static final int PreActive = 1;
    public static final int Active = 2;
    public static final int Deactivated = 3;
    public static final int Compromised = 4;
    public static final int Destroyed = 5;
    public static final int DestroyedCompromised = 6;
  }

  public static class RevocationReasonCode
  {
    public static final int Unspecified = 0x01;
    public static final int KeyCompromise = 0x02;
    public static final int CACompromise = 0x03;
    public static final int AffiliationChanged = 0x04;
    public static final int Superseded = 0x05;
    public static final int CessationofOperation = 0x06;
    public static final int PrivilegeWithdrawn = 0x07;
  }

  public static class LinkType
  {
    public static final int CertificateLink = 0x00000101;
    public static final int PublicKeyLink = 0x00000102;
    public static final int PrivateKeyLink = 0x00000103;
    public static final int DerivationBaseObjectLink = 0x00000104;
    public static final int DerivedKeyLink = 0x00000105;
    public static final int ReplacementObjectLink = 0x00000106;
    public static final int ReplacedObjectLink = 0x00000107;
    public static final int ParentLink = 0x00000108;
    public static final int ChildLink = 0x00000109;
    public static final int PreviousLink = 0x0000010A;
    public static final int NextLink = 0x0000010B;
    public static final int PKCS_12CertificateLink = 0x0000010C;
    public static final int PKCS_12PasswordLink = 0x0000010D;
  }

  public static class DerivationMethod
  {
    public static final int Pbkdf2 = 1;
    public static final int Hash = 2;
    public static final int Hmac = 3;
    public static final int Encrypt = 4;
    public static final int NIST800_108_C = 5;
    public static final int NIST800_108_F = 6;
    public static final int NIST800_108_DPI = 7;

    public static final int DyConcat = 0x80000001;
    public static final int DyEcdsaBipNormal = 0x80000002;
    public static final int DyEcdsaBipHardened = 0x80000003;
    public static final int DyEcdsaToEddsa = 0x80000004;
    public static final int DyEcdsaBipCaspHardened = 0x80000005;
    public static final int DyEddsaBipNormal = 0x80000006;
    public static final int DyEddsaBipHardened = 0x80000007;
    public static final int DyEddsaBipCaspHardened = 0x80000008;
  }

  public static class CertificateRequestType
  {
    public static final int CRMF = 0x01;
    public static final int PKCS_10 = 0x02;
    public static final int PEM = 0x03;
    public static final int PGP = 0x04;
  }

  public static class ValidityIndicator
  {
    public static final int Valid = 1;
    public static final int Invalid = 2;
    public static final int Unknown = 3;
  }

  public static class QueryFunction
  {
    public static final int QueryOperations = 0x01;
    public static final int QueryObjects = 0x02;
    public static final int QueryServerInformation = 0x03;
    public static final int QueryApplicationNamespaces = 0x04;
    public static final int QueryExtensionList = 0x05;
    public static final int QueryExtensionMap = 0x06;
    public static final int QueryAttestationTypes = 0x07;
    public static final int QueryRNGs = 0x08;
    public static final int QueryValidations = 0x09;
    public static final int QueryProfiles = 0x0A;
    public static final int QueryCapabilities = 0x0B;
    public static final int QueryClientRegistrationMethods = 0x0C;
  }

  public static class CancellationResult
  {
    public static final int Canceled = 0x01;
    public static final int UnableToCancel = 0x02;
    public static final int Completed = 0x03;
    public static final int Failed = 0x04;
    public static final int Unavailable = 0x05;
  }

  public static class PutFunction
  {
    public static final int New = 0x01;
    public static final int Replace = 0x02;
  }

  public static class Operation
  {
    public static final int Create = 0x01;
    public static final int CreateKeyPair = 0x02;
    public static final int Register = 0x03;
    public static final int ReKey = 0x04;
    public static final int DeriveKey = 0x05;
    public static final int Certify = 0x06;
    public static final int ReCertify = 0x07;
    public static final int Locate = 0x08;
    public static final int Check = 0x09;
    public static final int Get = 0x0a;
    public static final int GetAttributes = 0x0b;
    public static final int GetAttributeList = 0x0c;
    public static final int AddAttribute = 0x0d;
    public static final int ModifyAttribute = 0x0e;
    public static final int DeleteAttribute = 0x0f;
    public static final int ObtainLease = 0x10;
    public static final int GetUsageAllocation = 0x11;
    public static final int Activate = 0x12;
    public static final int Revoke = 0x13;
    public static final int Destroy = 0x14;
    public static final int Archive = 0x15;
    public static final int Recover = 0x16;
    public static final int Validate = 0x17;
    public static final int Query = 0x18;
    public static final int Cancel = 0x19;
    public static final int Poll = 0x1a;
    public static final int Notify = 0x1b;
    public static final int Put = 0x1c;
    public static final int ReKeyPair = 0x1d;
    public static final int DiscoverVersions = 0x1e;
    public static final int Encrypt = 0x1f;
    public static final int Decrypt = 0x20;
    public static final int Sign = 0x21;
    public static final int SignatureVerify = 0x22;
    public static final int MAC = 0x23;
    public static final int MACVerify = 0x24;
    public static final int RNGRetrieve = 0x25;
    public static final int RNGSeed = 0x26;
    public static final int Hash = 0x27;
    public static final int CreateSplitKey = 0x28;
    public static final int JoinSplitKey = 0x29;

    // dyadic proprietary operations
    public static final int DyCreate = 0x80000001;
    public static final int DyDestroy = 0x80000002;
    public static final int DyLocate = 0x80000003;
    public static final int DyGet = 0x80000004;
    public static final int DyModifyAttribute = 0x80000005;
    public static final int DyModifyAttributes = 0x80000006;
    public static final int DyRegister = 0x80000007;
    public static final int DyRefreshKey = 0x80000008;
    public static final int DyDerive = 0x80000009;
    public static final int DyWrap = 0x8000000a;
    public static final int DyUnWrap = 0x8000000b;
    public static final int DyUpdateData = 0x8000000c;
    public static final int DyAddPair = 0x8000000f;
    public static final int DyAddAuxiliary = 0x80000010;
    public static final int DyRemovePair = 0x80000011;
    public static final int DyRemoveAuxiliary = 0x80000012;
    public static final int DyGetTopology = 0x80000013;
    public static final int DyTestTopology = 0x80000014;
    public static final int DyLogin = 0x80000015;
    public static final int DyUpdateUserPassword = 0x80000016;
    public static final int DyRecoverSoPassword = 0x80000017;
    public static final int DyRecoverPartition = 0x80000018;
    public static final int DyGetAttributes = 0x80000019;
    public static final int DyGetRootCaCertificate = 0x80000020;
    public static final int DyGetQuorumTransaction = 0x80000021;
    public static final int DyListQuorumTransactions = 0x80000022;
    public static final int DyDeleteQuorumTransaction = 0x80000023;
    public static final int DyApproveQuorumTransaction = 0x80000024;
    public static final int DyGetSelfCertificate = 0x80000025;
    public static final int DyGetServerCertificate = 0x80000026;
    public static final int DyExecuteQuorumTransaction = 0x80000027;
    public static final int DyDestroySecretData = 0x80000028;
    public static final int DyUpdateSecretData = 0x80000029;
    public static final int DyRenewClientCertificate = 0x8000002a;
    public static final int DyUpdateRole = 0x8000002b;
    public static final int DyTestHealth = 0x8000002c;
    public static final int DyGetObjectGroups = 0x8000002d;
    public static final int DyChangePartitionUserRole = 0x8000002e;
    public static final int DyLogout = 0x8000002f;
    public static final int DyGetSystemKey = 0x80000030;

    public static final int DyCreateSecretData = 0x80000031;
    public static final int DyAddTriplet = 0x80000032;

    // these operations are used for authorization only, it do not
    // reflect a action which can be triggered externally
    // it is used to refine the operations list used for authorization
    public static final int DyCreatePartition = 0x80000040;
    public static final int DyDestroyPartition = 0x80000041;
    public static final int DyGetKeyMaterial = 0x80000042;
    public static final int DyGenerateTrustedKey = 0x80000043;
    public static final int DyGetSecretData = 0x80000044;
    public static final int DyCreateSoUser = 0x80000045;
    public static final int DyDeleteSoUser = 0x80000046;
    public static final int DyUpdateUserRetries = 0x80000047;
    public static final int DyDestroyStaticUsers = 0x80000048;
    public static final int DyDestroyStaticRoles = 0x80000049;

    public static final int DyModifyProtectedAttribute = 0x80000050;
    public static final int DyGetProtectedAttribute = 0x80000051;
    public static final int DySetQuorumTransaction = 0x80000052;
    public static final int DyRecoverQuorumValue = 0x80000053;
    public static final int DyUpdateSoLastActivity = 0x80000054;
    //        public static final int DyUpdateRollOperations =        0x80000054;
    public static final int DyCreateClient = 0x80000055;
    public static final int DyDeleteClient = 0x80000056;
    public static final int DyCreatePartitionUser = 0x80000057;
    public static final int DyDeletePartitionUser = 0x80000058;
    public static final int DyRecoverRootSoPassword = 0x80000059;
    public static final int DyLocatePartitions = 0x8000005a;
    public static final int DyGetPartition = 0x8000005b;
    public static final int DyCryptoDeriveKey = 0x8000005c;
    public static final int DyUpdateClientVersion = 0x8000005d;
    public static final int DyRefreshClientActivationCode = 0x8000005e;
    public static final int DyUpdateClient = 0x8000005f;

    public static final int DyGetObfuscatedAttribute = 0x80000060;
    public static final int DyPrecreateObject = 0x80000061;
    public static final int DyBackupDB = 0x80000062;
    public static final int DyRemoveFromCache = 0x80000063;
    public static final int DyUpdateReadOnlyAttributes = 0x80000064;
    public static final int DyListDbBackup = 0x80000065;
    public static final int DyDeleteDbBackup = 0x80000066;
    public static final int DyGetDbBackup = 0x80000067;
    public static final int DySignLogs = 0x80000068;

    public static final int DyRefreshClientSecret = 0x80000069;
    public static final int DyRefreshClientPublicKey = 0x8000006a;

    public static final int DyCreateRole = 0x8000006b;
    public static final int DyDeleteRole = 0x8000006c;
  }

  public static class ResultStatus
  {
    public static final int Success = 0x00;
    public static final int OperationFailed = 0x01;
    public static final int OperationPending = 0x02;
    public static final int OperationUndone = 0x03;
    public static final int DyFatalError = 0x80000001;
  }

  public static class ResultReason
  {
    public static final int ItemNotFound = 0x01;
    public static final int ResponseTooLarge = 0x02;
    public static final int AuthenticationNotSuccessful = 0x03;
    public static final int InvalidMessage = 0x04;
    public static final int OperationNotSupported = 0x05;
    public static final int MissingData = 0x06;
    public static final int InvalidField = 0x07;
    public static final int FeatureNotSupported = 0x08;
    public static final int OperationCanceledByRequester = 0x09;
    public static final int CryptographicFailure = 0x0a;
    public static final int IllegalOperation = 0x0b;
    public static final int PermissionDenied = 0x0c;
    public static final int ObjectArchived = 0x0d;
    public static final int IndexOutOfBounds = 0x0e;
    public static final int ApplicationNamespaceNotSupported = 0x0f;
    public static final int KeyFormatTypeNotSupported = 0x10;
    public static final int KeyCompressionTypeNotSupported = 0x11;
    public static final int EncodingOptionError = 0x12;
    public static final int KeyValueNotPresent = 0x13;
    public static final int AttestationRequired = 0x14;
    public static final int AttestationFailed = 0x15;
    public static final int GeneralFailure = 0x100;
    //public static final int PRF = 0x80000001;
  }

  public static class BatchErrorContinuationOption
  {
    public static final int Continue = 0x01;
    public static final int Stop = 0x02;
    public static final int Undo = 0x03;
  }

  public static class UsageLimitsUnit
  {
    public static final int Byte = 0x01;
    public static final int Object = 0x02;
  }

  public static class EncodingOption
  {
    public static final int NoEncoding = 0x01;
    public static final int TTLVEncoding = 0x02;
  }

  public static class ObjectGroupMember
  {
    public static final int GroupMemberFresh = 1;
    public static final int GroupMemberDefault = 2;
  }

  public static class AlternativeNameType
  {
    public static final int UninterpretedTextString = 0x01;
    public static final int URI = 0x02;
    public static final int ObjectSerialNumber = 0x03;
    public static final int EmailAddress = 0x04;
    public static final int DNSName = 0x05;
    public static final int X_500DistinguishedName = 0x06;
    public static final int IPAddress = 0x07;
  }

  public static class KeyValueLocationType
  {
    public static final int UninterpretedTextString = 0x01;
    public static final int URI = 0x02;
  }

  public static class RNGAlgorithm
  {
    public static final int Unspecified = 0x01;
    public static final int FIPS186_2 = 0x02;
    public static final int DRBG = 0x03;
    public static final int NRBG = 0x04;
    public static final int ANSIX9_31 = 0x05;
    public static final int ANSIX9_62 = 0x06;
    public static final int DyRngAlg = 0x80000001;
  }

  public static class DRBGAlgorithm
  {
    public static final int Unspecified = 0x01;
    public static final int Dual_EC = 0x02;
    public static final int Hash = 0x03;
    public static final int HMAC = 0x04;
    public static final int CTR = 0x05;
  }

  public static class ValidationAuthorityType
  {
    public static final int Unspecified = 0x01;
    public static final int NISTCMVP = 0x02;
    public static final int CommonCriteria = 0x03;
  }

  public static class ValidationType
  {
    public static final int Unspecified = 0x01;
    public static final int Hardware = 0x02;
    public static final int Software = 0x03;
    public static final int Firmware = 0x04;
    public static final int Hybrid = 0x05;
  }

  public static class UnwrapMode
  {
    public static final int Unspecified = 0x01;
    public static final int Processed = 0x02;
    public static final int NotProcessed = 0x03;
  }

  public static class DestroyAction
  {
    public static final int Unspecified = 0x01;
    public static final int KeyMaterialDeleted = 0x02;
    public static final int KeyMaterialShredded = 0x03;
    public static final int MetaDataDeleted = 0x04;
    public static final int MetaDataShredded = 0x05;
    public static final int Deleted = 0x06;
    public static final int Shredded = 0x07;
  }

  public static class ShreddingAlgorithm
  {
    public static final int Unspecified = 0x01;
    public static final int Cryptographic = 0x02;
    public static final int Unsupported = 0x03;
  }

  public static class RNGMode
  {
    public static final int Unspecified = 0x01;
    public static final int SharedInstantiation = 0x02;
    public static final int NonSharedInstantiation = 0x03;
  }

  public static class ClientRegistrationMethod
  {
    public static final int Unspecified = 0x01;
    public static final int ServerPreGenerated = 0x02;
    public static final int ServerOnDemand = 0x03;
    public static final int ClientGenerated = 0x04;
    public static final int ClientRegistered = 0x05;
  }

  public static class KeyWrapType
  {
    public static final int NotWrapped = 0x01;
    public static final int AsRegistered = 0x02;
  }

  public static class MaskGenerator
  {
    public static final int MGF1 = 0x01;
  }

  public static class CryptographicUsageMask
  {
    public static final int Sign = 0x00000001;
    public static final int Verify = 0x00000002;
    public static final int Encrypt = 0x00000004;
    public static final int Decrypt = 0x00000008;
    public static final int WrapKey = 0x00000010;
    public static final int UnwrapKey = 0x00000020;
    public static final int Export = 0x00000040;
    public static final int MACGenerate = 0x00000080;
    public static final int MACVerify = 0x00000100;
    public static final int DeriveKey = 0x00000200;
    public static final int ContentCommitment = 0x00000400;
    public static final int KeyAgreement = 0x00000800;
    public static final int CertificateSign = 0x00001000;
    public static final int CrlSign = 0x00002000;
    public static final int GenerateCryptogram = 0x00004000;
    public static final int ValidateCryptogram = 0x00008000;
    public static final int TranslateEncrypt = 0x00010000;
    public static final int TranslateDecrypt = 0x00020000;
    public static final int TranslateWrap = 0x00040000;
    public static final int TranslateUnwrap = 0x00080000;
  }

  // --------- Dy Enumerations -----------------

  public static class DyMode
  {
    public static final int None = 0;
    public static final int Activation = 1;
    public static final int Csr = 2;
    public static final int Full = 3;
    public static final int External = 4;
    public static final int Template = 5;
    public static final int Ephemeral = 6;
    public static final int Secret = 7;
    public static final int PublicKey = 8;
  }

  public static class DyPeriod
  {
    public static final int None = 0;
    public static final int LastDay = 1;
    public static final int LastWeek = 2;
    public static final int LastMonth = 3;
    public static final int LastYear = 4;
  }

  public static class DyGrantType
  {
    public static final int None = 0;
    public static final int ClientCredentials = 1;
    public static final int Password = 2;
    public static final int JwtBearer = 3;
  }

  public static class DyPartitionFipsRequirements
  {
    public static final int None = 0;
    public static final int Preferred = 1;
    public static final int Mandatory = 2;
  }
}
