package com.unbound.provider;

import java.security.*;

public final class RSAKeyPairGenerator extends KeyPairGeneratorSpi
{
  private Partition partition;
  private int bitSize;

  RSAKeyPairGenerator(Partition partition)
  {
    this.partition = partition;
  }

// --------------------- interface -----------------

  @Override
  public void initialize(int bitSize, SecureRandom random)
  {
    this.bitSize = bitSize;
    if (bitSize!=2048 && bitSize!=3072 && bitSize!=4096) throw new InvalidParameterException("Unsupported RSA key size " + bitSize);
  }

  @Override
  public KeyPair generateKeyPair()
  {
    UBRSAPrivateKey key = new UBRSAPrivateKey(partition);
    try
    {
      key.generate(bitSize, null);
    }
    catch (Exception e)
    {
      throw new ProviderException(e);
    }
    return new KeyPair(key.pub, key);
  }
}
