package com.unbound.provider;

import com.unbound.common.crypto.EC;

import java.security.*;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

public final class ECKeyPairGenerator extends KeyPairGeneratorSpi
{
  private Partition partition;
  private EC.Curve curve;

  ECKeyPairGenerator(Partition partition)
  {
    this.partition = partition;
  }

// --------------------- interface -----------------

  @Override
  public void initialize(int bitSize, SecureRandom random)
  {
    curve = EC.getCurveBySize(bitSize);
    if (curve == null) throw new InvalidParameterException("Unsupported EC key size " + bitSize);
  }

  @Override
  public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException
  {
    ECParameterSpec spec;

    if (params instanceof ECParameterSpec) spec = (ECParameterSpec)params;
    else if (params instanceof ECGenParameterSpec)
    {
      try
      {
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(params);
        spec = parameters.getParameterSpec(ECParameterSpec.class);
      }
      catch (Exception e) { throw new InvalidAlgorithmParameterException("Unsupported EC curve", e); }
    }
    else
    {
      throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
    }
    curve = EC.getCurve(spec);
    if (curve==null) throw new InvalidAlgorithmParameterException("Unsupported EC curve");
  }

  @Override
  public KeyPair generateKeyPair()
  {
    UBECPrivateKey key;
    try
    {
      key = new UBECPrivateKey(partition);
      key.generate(0,curve);
    }
    catch (Exception e)
    {
      throw new ProviderException(e);
    }
    return new KeyPair(key.pub, key);
  }
}
