package com.unbound.provider;

import com.unbound.common.crypto.SystemProvider;

import java.security.*;
import java.security.interfaces.ECPublicKey;
import java.security.spec.*;

public final class ECKeyFactory extends KeyFactorySpi
{
  private Partition partition;

  ECKeyFactory(Partition partition)
  {
    this.partition = partition;
  }

// --------------------- interface -----------------
  @Override
  protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException
  {
    return SystemProvider.KeyFactory.getInstance("EC").generatePublic(keySpec);
  }

  @Override
  protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException
  {
    if (keySpec == null) throw new InvalidKeySpecException("keySpec == null");

    if ((keySpec instanceof ECPrivateKeySpec) || (keySpec instanceof PKCS8EncodedKeySpec))
    {
        try { return new UBECPrivateKey(partition, keySpec); }
        catch (Exception e) { throw new InvalidKeySpecException(e); }
    }
    throw new InvalidKeySpecException("Must use ECPrivateKeySpec or PKCS8EncodedKeySpec; was " + keySpec.getClass().getName());
  }

  @Override
  protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException
  {
    if ((key == null) || (keySpec == null)) throw new InvalidKeySpecException("key and keySpec must not be null");

    if (key instanceof ECPublicKey && X509EncodedKeySpec.class.isAssignableFrom(keySpec))
    {
      return SystemProvider.KeyFactory.getInstance("EC").getKeySpec(key, keySpec);
    }

    if (key instanceof ECPublicKey && ECPublicKeySpec.class.isAssignableFrom(keySpec))
    {
      return (T) new ECPublicKeySpec(((ECPublicKey)key).getW(), ((ECPublicKey)key).getParams());
    }

    throw new InvalidKeySpecException("Could not encode key");
  }

  @Override
  protected Key engineTranslateKey(Key key) throws InvalidKeyException
  {
    return key;
  }
}
