package com.unbound.provider;

import com.unbound.common.Log;
import com.unbound.common.crypto.PKCS10;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.common.crypto.X509;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.request.RequestItem;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.request.dy.DyRegisterClientRequest;
import com.unbound.provider.kmip.response.ResponseItem;
import com.unbound.provider.kmip.response.ResponseMessage;
import com.unbound.provider.kmip.response.dy.DyRegisterClientResponse;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;

public class Client
{
  public static Partition register(String partitionName, String clientName, String templateName, String activationCode) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException
  {
    Log log = Log.func("Client.register")
      .log("partitionName", partitionName)
      .log("clientName", clientName)
      .log("templateName", templateName)
      .log("activationCode", activationCode)
      .end();
    try
    {
      ArrayList<InetAddress> ipList = new ArrayList<>();
      Enumeration e = NetworkInterface.getNetworkInterfaces();
      while (e.hasMoreElements())
      {
        NetworkInterface n = (NetworkInterface) e.nextElement();
        Enumeration ee = n.getInetAddresses();
        while (ee.hasMoreElements())
        {
          InetAddress i = (InetAddress) ee.nextElement();
          if (i instanceof Inet4Address) ipList.add(i);
          //else if (i instanceof Inet6Address)
        }
      }

      InetAddress[] ip = ipList.isEmpty() ? null : ipList.toArray(new InetAddress[ipList.size()]);

      if (clientName==null) clientName = InetAddress.getLocalHost().getHostName();

      KeyPairGenerator rsaGen = SystemProvider.KeyPairGenerator.getInstance("RSA");
      rsaGen.initialize(2048);
      KeyPair rsaKeyPair = rsaGen.generateKeyPair();

      PKCS10 pkcs10 = new PKCS10((java.security.interfaces.RSAPublicKey) rsaKeyPair.getPublic());
      pkcs10.setSubjectName("CN", clientName);
      pkcs10.setSubjectName("OU", partitionName);
      pkcs10.setChallengePassword(activationCode);
      pkcs10.setAlternativeSubjectName(new String[]{clientName}, ip);
      pkcs10.sign((java.security.interfaces.RSAPrivateKey) rsaKeyPair.getPrivate(), "SHA256");
      byte[] csr = pkcs10.exportDer();

      /*FileOutputStream fos = new FileOutputStream("c:\\temp\\test.csr");
      fos.write(buf);
      fos.close();*/

      DyRegisterClientRequest req = new DyRegisterClientRequest();
      req.csr = csr;
      req.name = clientName;
      req.partitionName = partitionName;
      req.template = templateName;

      DyRegisterClientResponse resp = (DyRegisterClientResponse)transmit(null, req);
      X509Certificate[] chain = new X509Certificate[2];
      chain[0] = X509.get(resp.clientCertificate);
      chain[1] = X509.get(resp.rootCaCertificate);

      KeyStore keyStore = KeyStore.getInstance("JKS");
      keyStore.load(null, null);
      String pfxPassword = "UNBOUND";
      keyStore.setKeyEntry(clientName, rsaKeyPair.getPrivate(), pfxPassword.toCharArray(), chain);
      return Partition.registerPfx(keyStore, pfxPassword);
    }
    catch (Exception e) { log.failed(e); throw e; } finally { log.leave(); }
  }

  static byte[] transmit(Partition partition, byte[] in) throws IOException
  {
    Server[] servers = Server.getList();
    int retry = servers.length;
    for (Server server : servers)
    {
      try
      {
        return server.transmit(partition, in);
      }
      catch (Exception e)
      {
        retry--;
        if (retry == 0) throw e;
      }
    }
    throw new IOException("No servers found");
  }

  static ResponseMessage transmit(Partition partition, RequestMessage req) throws IOException
  {
    Log log = Log.func("Client.transmit").end(); try
    {
      try
      {
        byte[] in = KMIPConverter.convert(req);
        byte[] out = transmit(partition, in);
        ResponseMessage resp = KMIPConverter.convertResponseMessage(out);
        if (resp.header.batchCount == 0)
        {
          throw new KMIPConvertException("Invalid KMIP response");
        }
        ResponseItem item = resp.batch.get(0);
        if (item.result_status != KMIP.ResultStatus.Success)
        {
          throw new ProviderException("KMIP error " + item.reason + " " + item.resultMsg);
        }
        return resp;
      }
      catch (Exception e)
      {
        throw new ProviderException(e);
      }
    }
    catch (Exception e) { log.failed(e); throw e; } finally { log.leave(); }
  }

  static ResponseItem transmit(Partition partition, RequestItem req) throws IOException
  {
    RequestMessage reqMsg = new RequestMessage();
    reqMsg.batch.add(req);
    ResponseMessage respMsg = transmit(partition, reqMsg);
    return respMsg.batch.get(0);
  }



}
