package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.*;

import java.security.KeyStoreException;

/**
 * Created by valery.osheter on 15-Mar-17.
 */
class UnwrapInfo
{
    final CK_MECHANISM mechanism;
    final CKKey pkcs11Key;
    final byte[] wrapped;

    UnwrapInfo(CK_MECHANISM mechanism, CKKey pkcs11Key, byte[] wrapped)
    {
        this.mechanism = mechanism;
        this.pkcs11Key = pkcs11Key;
        this.wrapped = wrapped;
    }

    <T extends CKKey> T unwrap(Class<T> c, CK_ATTRIBUTE[] t) throws KeyStoreException
    {
        try { return pkcs11Key.unwrap(c, mechanism, wrapped, t); }
        catch (CKException e) { throw new KeyStoreException(e); }
    }

}
