package com.dyadicsec.provider;

import static com.dyadicsec.cryptoki.CK.*;

import javax.crypto.*;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

/**
 * Created by saar.peer on 29-Jun-16.
 */
public class SecretKeyGenerator extends KeyGeneratorSpi
{
    private int bitSize = 128;
    private final int keyType;
    KeyParameters keyParams = null;

    SecretKeyGenerator(int keyType)
    {
        this.keyType = keyType;
        if (keyType== CKK_DES3) bitSize = 192;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {}

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException
    {
        if (!(paramSpec instanceof KeyGenSpec)) throw new InvalidAlgorithmParameterException("AES key generation does not take any parameters");
        KeyGenSpec spec = (KeyGenSpec)paramSpec;
        keyParams = spec.params;
        engineInit(spec.bitSize, secureRandom);
    }

    @Override
    protected void engineInit(int bitSize, SecureRandom secureRandom)
    {
        switch (keyType)
        {
            case CKK_AES:
                if (bitSize != 128 && bitSize != 192 && bitSize != 256)
                {
                    throw new InvalidParameterException("Wrong key size: must be equal to 128, 192 or 256");
                }
                break;

            case DYCKK_AES_XTS:
            case DYCKK_AES_SIV:
                if (bitSize != 256 && bitSize != 512)
                {
                    throw new InvalidParameterException("Wrong key size: must be equal to 256 or 512");
                }
                break;

            case CKK_DES3:
                if (bitSize!=192)
                {
                    throw new InvalidParameterException("Wrong key size: must be equal to 192");
                }
                break;
        }
        this.bitSize = bitSize;
    }

    @Override
    protected SecretKey engineGenerateKey()
    {
        return new SecretKey().initForGenerate(keyParams, keyType, bitSize);
    }

    public static final class AES extends SecretKeyGenerator
    {
        public AES() { super(CKK_AES); }
    }

    public static final class AESXTS extends SecretKeyGenerator
    {
        public AESXTS() { super(DYCKK_AES_XTS); }
    }

    public static final class AESSIV extends SecretKeyGenerator
    {
        public AESSIV() { super(DYCKK_AES_SIV); }
    }

    public static final class DES3 extends SecretKeyGenerator
    {
        public DES3() { super(CKK_DES3); }
    }

    public static final class Hmac extends SecretKeyGenerator
    {
        public Hmac() { super(CKK_GENERIC_SECRET); }
    }

}
