package com.dyadicsec.provider;

import static com.dyadicsec.cryptoki.CK.*;

import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.spec.*;

/**
 * Created by saar.peer on 29-Jun-16.
 */
public class SecretKeyFactory extends SecretKeyFactorySpi
{
    private final int keyType;

    SecretKeyFactory(int keyType)
    {
        this.keyType = keyType;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException
    {
        if (keySpec == null) throw new InvalidKeySpecException("keySpec == null");

        KeyParameters keyParams = null;
        KeyFactorySpec keyFactorySpec = null;
        if (keySpec instanceof KeyFactorySpec)
        {
            keyFactorySpec = (KeyFactorySpec) keySpec;
            keySpec = keyFactorySpec.original;
            keyParams = keyFactorySpec.params;
        }

        if (keySpec instanceof SecretKeySpec)
        {
            try { return new com.dyadicsec.provider.SecretKey().initForImport(keyParams, keyType, (SecretKeySpec)keySpec); }
            catch (KeyStoreException e) { throw new InvalidKeySpecException(e); }
        }

        throw new InvalidKeySpecException("Must use SecretKeySpec or KeyFactorySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class<?> keySpec) throws InvalidKeySpecException
    {
        throw new InvalidKeySpecException("Could not encode key");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException
    {
        if (secretKey == null) throw new InvalidKeyException("CKKey must not be null");
        if (secretKey instanceof com.dyadicsec.provider.SecretKey) return secretKey;
        if (secretKey instanceof SecretKeySpec)
        {
            try { return new com.dyadicsec.provider.SecretKey().initForImport(null, keyType, (SecretKeySpec)secretKey); }
            catch (KeyStoreException e) { throw new InvalidKeyException(e); }
        }
        throw new InvalidKeyException("CKKey must be instance of CKSecretKey or SecretKeySpec");
    }

    public static final class AES extends SecretKeyFactory
    {
        public AES() { super(CKK_AES); }
    }

    public static final class AESXTS extends SecretKeyFactory
    {
        public AESXTS() { super(DYCKK_AES_XTS); }
    }

    public static final class AESSIV extends SecretKeyFactory
    {
        public AESSIV() { super(DYCKK_AES_SIV); }
    }

    public static final class DES3 extends SecretKeyFactory
    {
        public DES3() { super(CKK_DES3); }
    }

    public static final class Hmac extends SecretKeyFactory
    {
        public Hmac() { super(CKK_GENERIC_SECRET); }
    }
}
