package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.*;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;

/**
 * Created by valery.osheter on 19-Apr-16.
 */
public final class RSAPublicKey implements java.security.interfaces.RSAPublicKey
{
    private static final long serialVersionUID = 1L;

    private java.security.interfaces.RSAPublicKey sw = null;
    RSAPrivateKey prvKey = null;

    RSAPublicKey()
    {
    }

    RSAPublicKey(KeySpec keySpec, KeyParameters keyParams) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException
    {
        init(keySpec);
    }

    RSAPublicKey(java.security.interfaces.RSAPublicKey key)
    {
        sw = key;
    }

    private void init(KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException
    {
        KeyFactory kf = null;

        try { kf = KeyFactory.getInstance("RSA", "SunRsaSign"); }
        catch (NoSuchProviderException e) { kf = null; }
        catch (NoSuchAlgorithmException e) { kf = null; }

        if (kf==null) try { kf = KeyFactory.getInstance("RSA", "IBMJCE"); }
        catch (NoSuchProviderException e) { kf = null; }
        catch (NoSuchAlgorithmException e) { kf = null; }

        if (kf==null) kf = KeyFactory.getInstance("RSA", "IBMJSSE2");

        sw = (java.security.interfaces.RSAPublicKey) kf.generatePublic(keySpec);
    }

    void init(BigInteger N, BigInteger E) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException
    {
        init(new RSAPublicKeySpec(N, E));
    }

    @Override
    public BigInteger getModulus() { return getSoftwareKey().getModulus(); }

    @Override
    public BigInteger getPublicExponent() { return getSoftwareKey().getPublicExponent(); }

    @Override
    public String getAlgorithm() { return "RSA"; }

    @Override
    public String getFormat() { return getSoftwareKey().getFormat();  }

    @Override
    public byte[] getEncoded() { return getSoftwareKey().getEncoded(); }

    int getBitSize() { return Utils.bigIntByteSize(getModulus()) *8;}

    java.security.interfaces.RSAPublicKey getSoftwareKey()
    {
        if (sw!=null) return sw;
        if (prvKey!=null) try { prvKey.save(); }
        catch (KeyStoreException e) { return null; }
        return sw;
    }

    void createTrusted(KeyStore store, String alias) throws KeyStoreException
    {
        BigInteger E = sw.getPublicExponent();
        BigInteger N = sw.getModulus();
        Policy policy = new Policy();
        policy.setTrusted(true);

        try { CKRSAPublicKey.create(store.slot, alias, policy, N, E); }
        catch (CKException e) { throw new KeyStoreException(e); }
    }
}
