package com.dyadicsec.provider;

import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

/**
 * Created by valery.osheter on 01-Dec-16.
 */
public class MessageDigest extends MessageDigestSpi
{
    private java.security.MessageDigest sys;

    MessageDigest(String name)
    {
        try { sys = java.security.MessageDigest.getInstance(name, "SUN"); }
        catch (NoSuchAlgorithmException e) { sys = null; }
        catch (NoSuchProviderException e) { sys = null; }

        if (sys==null)
        {
            try { sys = java.security.MessageDigest.getInstance(name); }
            catch (NoSuchAlgorithmException e) { sys = null; }
        }
    }

    @Override
    protected void engineUpdate(byte input) { sys.update(input); }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) { sys.update(input, offset, len); }

    @Override
    protected byte[] engineDigest() { return sys.digest(); }

    @Override
    protected void engineReset() { sys.reset(); }

    public static final class SHA1   extends MessageDigest { public SHA1()   { super("SHA-1");   }  }
    public static final class SHA256 extends MessageDigest { public SHA256() { super("SHA-256"); }  }
    public static final class SHA384 extends MessageDigest { public SHA384() { super("SHA-384"); }  }
    public static final class SHA512 extends MessageDigest { public SHA512() { super("SHA-512"); }  }
}
