package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKLIMAPrivateKey;
import com.dyadicsec.pkcs11.CKPrivateKey;

import java.security.KeyStoreException;
import java.security.PrivateKey;

/**
 * Created by valery.osheter on 21-Mar-17.
 */
public class LIMAPrivateKey extends DYKey implements PrivateKey
{
    private static final long serialVersionUID = 1L;

    KeyParameters keyParams = null;
    private LIMAPublicKey genPublicKey = null;
    CKLIMAPrivateKey pkcs11Key = null;

    LIMAPrivateKey()
    {
    }

    LIMAPrivateKey(CKLIMAPrivateKey pkcs11Key)
    {
        this.pkcs11Key = pkcs11Key;
    }

    @Override
    protected CKPrivateKey getPkcs11Key() { return pkcs11Key;}

    LIMAPrivateKey initForGenerate(KeyParameters keyParams, LIMAPublicKey genPublicKey)
    {
        this.keyParams = keyParams;
        this.genPublicKey = genPublicKey;
        genPublicKey.prvKey = this;
        return this;
    }

    @Override
    protected void generate(KeyStore store, String alias) throws KeyStoreException
    {
        try { pkcs11Key = CKLIMAPrivateKey.generate(store.slot, alias, KeyParameters.toPolicy(keyParams)); }
        catch (CKException e) { throw new KeyStoreException(e); }

        if (genPublicKey!=null)
        {
            try { genPublicKey.pkcs11Key = pkcs11Key.getPublicKey(); }
            catch (Throwable e) { throw new KeyStoreException(e); }
        }
    }

    public LIMAPublicKey getPublicKey() throws KeyStoreException
    {
        if (genPublicKey==null)
        {
            if (pkcs11Key!=null)
            {
                try { genPublicKey = new LIMAPublicKey(pkcs11Key.getPublicKey()); }
                catch (CKException e) { throw new KeyStoreException(e); }
            }
        }
        return genPublicKey;
    }

    @Override
    public String getAlgorithm()
    {
        return "LIMA";
    }

    @Override
    public String getFormat()
    {
        return "N/A";
    }

    @Override
    public byte[] getEncoded()
    {
        return null;
    }

}
