package com.dyadicsec.provider;

import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.KeyPair;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;

/**
 * Created by valery.osheter on 21-Mar-17.
 */
public class LIMAKeyPairGenerator extends KeyPairGeneratorSpi
{
    private KeyParameters keyParams = null;

    @Override
    public void initialize(int keysize, SecureRandom random)
    {

    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException
    {
        if (params instanceof KeyGenSpec)
        {
            KeyGenSpec keyGenSpec = (KeyGenSpec) params;
            keyParams = keyGenSpec.params;
        }
    }

    @Override
    public KeyPair generateKeyPair()
    {
        LIMAPublicKey pubKey = new LIMAPublicKey();
        LIMAPrivateKey prvKey = null;

        try { prvKey = new LIMAPrivateKey().initForGenerate(keyParams, pubKey); }
        catch (Throwable e) { return null; }

        return new KeyPair(pubKey, prvKey);
    }
}
