package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.Policy;

/**
 * Created by valery.osheter on 15-Mar-17.
 */
public class KeyParameters
{
    private boolean allowEncrypt=true;
    private boolean allowDecrypt=true;
    private boolean allowSign=true;
    private boolean allowVerify=true;
    private boolean allowDerive=true;
    private boolean extractable=false;
    private boolean sensitive=true;
    private boolean trusted=false;

    public void setAllowEncrypt(boolean v)  { allowEncrypt = v; }
    public void setAllowDecrypt(boolean v)  { allowDecrypt = v; }
    public void setAllowSign   (boolean v)  { allowSign = v; }
    public void setAllowVerify (boolean v)  { allowVerify = v; }
    public void setAllowDerive (boolean v)  { allowDerive = v; }
    public void setTrusted     (boolean v)  { trusted = v; }
    public void setExtractable (boolean v)  { extractable = v; }
    public void setSensitive   (boolean v)  { sensitive = v; }

    public boolean isAllowEncrypt()  { return allowEncrypt; }
    public boolean isAllowDecrypt()  { return allowDecrypt; }
    public boolean isAllowSign()     { return allowSign; }
    public boolean isAllowVerify()   { return allowVerify; }
    public boolean isAllowDerive()   { return allowDerive; }
    public boolean isTrusted()       { return trusted; }
    public boolean isExtractable()   { return extractable; }
    public boolean isSensitive()     { return sensitive; }

    static Policy toPolicy(KeyParameters params)
    {
        if (params==null) return null;
        Policy policy = new Policy();
        policy.setEncrypt(params==null || params.allowEncrypt);
        policy.setDecrypt(params==null || params.allowDecrypt);
        policy.setSign(params==null || params.allowSign);
        policy.setVerify(params==null || params.allowVerify);
        policy.setDerive(params==null || params.allowDerive);
        policy.setExtractable(params!=null && params.extractable);
        policy.setSensitive(params==null || params.sensitive);
        policy.setTrusted(params!=null && params.trusted);
        return policy;
    }
}
