package com.dyadicsec.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class EDDSAKeyPairGenerator extends KeyPairGeneratorSpi
{
    private KeyParameters keyParams = null;

    @Override
    public void initialize(int keysize, SecureRandom random)
    {

    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random)
    {
        if (params instanceof KeyGenSpec)
        {
            KeyGenSpec keyGenSpec = (KeyGenSpec) params;
            keyParams = keyGenSpec.params;
        }
    }

    @Override
    public KeyPair generateKeyPair()
    {
        EDDSAPublicKey pubKey = new EDDSAPublicKey();
        EDDSAPrivateKey prvKey = null;

        try { prvKey = new EDDSAPrivateKey().initForGenerate(keyParams, pubKey); }
        catch (Throwable e) { return null; }

        return new KeyPair(pubKey, prvKey);
    }
}
