package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.ECCurve;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.*;

/**
 * Created by valery.osheter on 19-Apr-16.
 */
public final class ECPublicKey implements java.security.interfaces.ECPublicKey
{
    private static final long serialVersionUID = 1L;

    private java.security.interfaces.ECPublicKey sw = null;
    ECPrivateKey prvKey = null;

    ECPublicKey()
    {
    }

    private void init(KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory kf;
        try {
            kf = KeyFactory.getInstance("EC", "SunEC");
        } catch (NoSuchProviderException e) {
            kf = null;
        } catch (NoSuchAlgorithmException e) {
            kf = null;
        }

        if (kf == null) {
            kf = KeyFactory.getInstance("EC", "IBMJCE");
        }

        sw = (java.security.interfaces.ECPublicKey) kf.generatePublic(keySpec);
    }

    ECPublicKey(KeySpec keySpec, KeyParameters keyParams) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException
    {
        init(keySpec);
    }

    void init(ECCurve curve, ECPoint point) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, NoSuchProviderException
    {
        ECPublicKeySpec keySpec = new ECPublicKeySpec(point, curve.getSpec());
        init(keySpec);
    }

    ECPublicKey(java.security.interfaces.ECPublicKey key)
    {
        sw = key;
    }

    ECPublicKey(ECPoint w, ECParameterSpec params) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException
    {
        init(new ECPublicKeySpec(w, params));
    }

    @Override
    public ECPoint getW() { return getSoftwareKey().getW(); }

    @Override
    public ECParameterSpec getParams() { return getSoftwareKey().getParams(); }

    @Override
    public String getAlgorithm() { return "EC"; }

    @Override
    public String getFormat() {  return getSoftwareKey().getFormat();  }

    @Override
    public byte[] getEncoded() { return getSoftwareKey().getEncoded(); }

    java.security.interfaces.ECPublicKey getSoftwareKey()
    {
        if (sw!=null) return sw;
        if (prvKey!=null) try { prvKey.save(); }
        catch (KeyStoreException e) { return null; }
        return sw;
    }

}
