package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.*;


import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.KeyStoreException;
import java.security.KeyFactory;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

/**
 * Created by valery.osheter on 19-Apr-16.
 */
public final class ECPrivateKey extends DYKey implements java.security.interfaces.ECPrivateKey
{
    private static final long serialVersionUID = 1L;

    private java.security.interfaces.ECPrivateKey sw = null;
    private ECPublicKey genPublicKey = null;
    KeyParameters keyParams = null;
    ECCurve curve = null;
    CKECPrivateKey pkcs11Key = null;
    private UnwrapInfo unwrapInfo = null;

    ECPrivateKey()
    {
    }

    ECPrivateKey(CKECPrivateKey pkcs11Key)
    {
        this.pkcs11Key = pkcs11Key;
    }

    @Override
    protected CKPrivateKey getPkcs11Key() { return pkcs11Key;}

    ECPrivateKey initForUnwrap(UnwrapInfo unwrapInfo)
    {
        this.unwrapInfo = unwrapInfo;
        return this;
    }

    ECPrivateKey initForImport(KeyParameters keyParams, KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, KeyStoreException {
        this.keyParams = keyParams;
        try {
            this.sw = (java.security.interfaces.ECPrivateKey) KeyFactory.getInstance("EC", "SunEC").generatePrivate(keySpec);
        } catch (NoSuchProviderException e) {
            this.sw = null;
        } catch (NoSuchAlgorithmException e) {
            this.sw = null;
        }

        if (this.sw == null) {
            this.sw = (java.security.interfaces.ECPrivateKey) KeyFactory.getInstance("EC", "IBMJCE").generatePrivate(keySpec);
        }
        curve = ECCurve.find(sw.getParams());
        if (curve == null) throw new KeyStoreException("Unsupported EC curve");
        return this;
    }


    ECPrivateKey initForImport(java.security.interfaces.ECPrivateKey key) throws KeyStoreException
    {
        sw = key;
        curve = ECCurve.find(sw.getParams());
        if (curve==null) throw new KeyStoreException("Unsupported EC curve");
        return this;
    }

    ECPrivateKey initForGenerate(KeyParameters keyParams, ECPublicKey genPublicKey, ECCurve curve)
    {
        this.keyParams = keyParams;
        this.curve = curve;
        this.genPublicKey = genPublicKey;
        genPublicKey.prvKey = this;
        return this;
    }

    private ECCurve getCurve() throws KeyStoreException
    {
        if (curve==null)
        {
            try { curve = pkcs11Key.getCurve(); }
            catch (CKException e) { throw new KeyStoreException(e); }
        }
        return curve;
    }

    @Override
    protected void create(KeyStore store, String alias) throws KeyStoreException
    {
        try { pkcs11Key = CKECPrivateKey.create(store.slot, alias, KeyParameters.toPolicy(keyParams), curve, sw.getS()); }
        catch (CKException e) { throw new KeyStoreException(e); }
    }

    @Override
    protected void generate(KeyStore store, String alias) throws KeyStoreException
    {
        try { pkcs11Key = CKECPrivateKey.generate(store.slot, alias, KeyParameters.toPolicy(keyParams), curve); }
        catch (CKException e) { throw new KeyStoreException(e); }

        if (genPublicKey!=null)
        {
            try { genPublicKey.init(curve, pkcs11Key.getPoint()); }
            catch (Throwable e) { throw new KeyStoreException(e); }
        }
    }

    @Override
    protected void unwrap(String alias) throws KeyStoreException
    {
        CK_ATTRIBUTE[] t = CKECPrivateKey.getUnwrapTemplate(alias, KeyParameters.toPolicy(keyParams));
        pkcs11Key = unwrapInfo.unwrap(CKECPrivateKey.class, t);
        unwrapInfo = null;
    }

    @Override
    protected boolean swKeyPresent() {return sw != null;}
    @Override
    protected boolean unwrapInfoPresent() {return unwrapInfo != null;}

    @Override
    public BigInteger getS() { return null; }//sw!=null ? sw.getS() : null; }

    @Override
    public ECParameterSpec getParams()
    {
        try { return getCurve().getSpec(); }
        catch (KeyStoreException e) { throw new ProviderException(e); }
    }

    @Override
    public String getAlgorithm() { return "EC"; }

    @Override
    public String getFormat() { return sw!=null ? sw.getFormat() : "PKCS#8"; }

    @Override
    public byte[] getEncoded() { return sw!=null ? sw.getEncoded() : null; }
}
