package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.ECCurve;

import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.InvalidParameterException;
import java.security.InvalidAlgorithmParameterException;
import java.security.AlgorithmParameters;
import java.security.KeyPair;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

/**
 * Created by valery.osheter on 19-Apr-16.
 */
public final class ECKeyPairGenerator extends KeyPairGeneratorSpi
{
    private KeyParameters keyParams = null;
    private ECCurve curve = null;

    @Override
    public void initialize(int keySize, SecureRandom random)
    {
        curve = ECCurve.find(keySize);
        if (curve == null) throw new InvalidParameterException("Unsupported EC key size " + keySize);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException
    {
        ECParameterSpec spec = null;

        KeyGenSpec keyGenSpec = null;
        if (params instanceof KeyGenSpec)
        {
            keyGenSpec = (KeyGenSpec) params;
            params = keyGenSpec.original;
            keyParams = keyGenSpec.params;
            if (params==null)
            {
                initialize(keyGenSpec.bitSize, random);
                return;
            }
        }

        if (params instanceof ECParameterSpec) spec = (ECParameterSpec)params;
        else if (params instanceof ECGenParameterSpec)
        {
            try
            {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                parameters.init((ECGenParameterSpec)params);
                spec = parameters.getParameterSpec(ECParameterSpec.class);
            }
            catch (Exception e) { throw new InvalidAlgorithmParameterException("Unsupported EC curve", e); }
        }
        else
        {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        curve = ECCurve.find(spec);
        if (curve==null) throw new InvalidAlgorithmParameterException("Unsupported EC curve");
    }

    @Override
    public KeyPair generateKeyPair()
    {
        ECPublicKey pubKey = new ECPublicKey();
        ECPrivateKey prvKey = null;

        try { prvKey = new ECPrivateKey().initForGenerate(keyParams, pubKey, curve); }
        catch (Exception e) { return null; }

        return new KeyPair(pubKey, prvKey);
    }

}
