package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKKey;

import java.security.Key;
import java.security.KeyStoreException;

public abstract class DYKey implements Key {

    protected abstract CKKey getPkcs11Key();
    protected abstract void generate(KeyStore store, String alias) throws KeyStoreException;
    protected void create(KeyStore store, String alias) throws KeyStoreException {}
    protected void unwrap(String alias) throws KeyStoreException {}

    protected boolean swKeyPresent() {return false;}
    protected boolean unwrapInfoPresent() {return false;}

    void save(KeyStore store, String alias) throws KeyStoreException
    {
        if (getPkcs11Key() != null)
        {
            if (alias == null) return;
            store.setAlias(this, alias);
        }
        else
        {
            if (unwrapInfoPresent())
                unwrap(alias);
            else if (swKeyPresent())
                create(store, alias);
            else
                generate(store, alias);
            store.register(this, alias);
        }
    }

    void save() throws KeyStoreException
    {
        save(DYCryptoProvider.defaultKeyStore, null);
    }

    @Override
    public String getFormat()
    {
        return "N/A";
    }

    @Override
    public byte[] getEncoded()
    {
        return null;
    }

}
