package com.dyadicsec.pkcs11;

/**
 * Created by valery.osheter on 25-Jun-17.
 */
public final class Policy
{
    //static final Policy default_ = new Policy();

    boolean cka_token = true;
    boolean cka_private = false;
    boolean cka_trusted = false;
    boolean cka_sensitive = true;
    boolean cka_extractable = false;
    boolean cka_derive = true;
    boolean cka_wrap = true;
    boolean cka_unwrap = true;
    boolean cka_encrypt = true;
    boolean cka_decrypt = true;
    boolean cka_sign = true;
    boolean cka_verify = true;

    public Policy setToken(boolean v)       { cka_token       = v; return this; }
    public Policy setPrivate(boolean v)     { cka_private     = v; return this; }
    public Policy setTrusted(boolean v)     { cka_trusted     = v; return this; }
    public Policy setSensitive(boolean v)   { cka_sensitive   = v; return this; }
    public Policy setExtractable(boolean v) { cka_extractable = v; return this; }
    public Policy setDerive(boolean v)      { cka_derive      = v; return this; }
    public Policy setWrap(boolean v)        { cka_wrap        = v; return this; }
    public Policy setUnwrap(boolean v)      { cka_unwrap      = v; return this; }
    public Policy setEncrypt(boolean v)     { cka_encrypt     = v; return this; }
    public Policy setDecrypt(boolean v)     { cka_decrypt     = v; return this; }
    public Policy setSign(boolean v)        { cka_sign        = v; return this; }
    public Policy setVerify(boolean v)      { cka_verify      = v; return this; }

    public boolean getToken()               { return cka_token;       }
    public boolean getPrivate()             { return cka_private;     }
    public boolean getTrusted()             { return cka_trusted;     }
    public boolean getSensitive()           { return cka_sensitive;   }
    public boolean getExtractable()         { return cka_extractable; }
    public boolean getDerive()              { return cka_derive;      }
    public boolean getWrap()                { return cka_wrap;        }
    public boolean getUnwrap()              { return cka_unwrap;      }
    public boolean getEncrypt()             { return cka_encrypt;     }
    public boolean getDecrypt()             { return cka_decrypt;     }
    public boolean getSign()                { return cka_sign;        }
    public boolean getVerify()              { return cka_verify;      }
}
