package com.dyadicsec.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

/**
 * Created by valery.osheter on 21-Apr-16.
 */
public final class DER
{
    public final static byte TAG_INTEGER = 0x02;
    public final static byte TAG_OCTETSTRING = 0x04;
    public final static byte TAG_SEQUENCE = 0x30;

    public static byte[] cat(byte[]... list)
    {
        int size = 0;
        for (byte[] src : list) size += src.length;
        byte[] out = new byte[size];
        int offset = 0;
        for (int i=0; i<list.length; i++)
        {
            byte[] src = list[i];
            System.arraycopy(list[i], 0, out, offset, src.length);
            offset += src.length;
        }
        return out;
    }

    public static byte[] encode(byte tag, byte[] data)
    {
        int outLen = 2 + data.length;
        if (data.length>127) outLen++;
        if (data.length>256) outLen++;
        byte[] out = new byte[outLen];
        out[0] = tag;
        if (data.length<=127) out[1] = (byte)data.length;
        else if (data.length<256) { out[1] = (byte)0x81; out[2] = (byte)data.length; }
        else { out[1] = (byte)0x82; out[2] = (byte)(data.length>>8); out[3] = (byte)data.length; }
        System.arraycopy(data, 0, out, outLen-data.length, data.length);
        return out;
    }

    public static byte[] encode(BigInteger value)
    {
        return encode(TAG_INTEGER, value.toByteArray());
    }

    public static byte[] decode(byte tag, byte[] data) throws IOException
    {
        int n = data.length;
        int q = 0;
        if ((n == 0) || (data[q++] != tag)) throw new IOException("DER format error");
        n--;
        if (n == 0) throw new IOException("DER format error");
        int s = data[q++] & 0xff;
        n--;
        if ((s & 0x80)!=0)
        {
            int slen = s & 0x7f;
            if (n<slen) throw new IOException("DER format error");
            n -= slen;
            s = 0;
            for (int i=0; i<slen; i++) { s<<=8; s |= (data[q++] & 0xff); }
        }
        if (n!=s) throw new IOException("DER format error");
        return Arrays.copyOfRange(data, q, data.length);
    }
}
