package com.dyadicsec.pkcs11;


import com.dyadicsec.cryptoki.CK;

import java.security.InvalidParameterException;


/**
 * Created by valery.osheter on 18-Apr-16.
 */
public final class CK_ATTRIBUTE
{
    int type;
    byte[] value;
    int intValue;

    static final int[] boolAttrList =
            {
                    CK.CKA_TOKEN,
                    CK.CKA_PRIVATE,
                    CK.CKA_SENSITIVE,
                    CK.CKA_ENCRYPT,
                    CK.CKA_DECRYPT,
                    CK.CKA_WRAP,
                    CK.CKA_UNWRAP,
                    CK.CKA_SIGN,
                    CK.CKA_SIGN_RECOVER,
                    CK.CKA_VERIFY,
                    CK.CKA_VERIFY_RECOVER,
                    CK.CKA_DERIVE,
                    CK.CKA_EXTRACTABLE,
                    CK.CKA_LOCAL,
                    CK.CKA_NEVER_EXTRACTABLE,
                    CK.CKA_ALWAYS_SENSITIVE,
                    CK.CKA_MODIFIABLE,
                    CK.CKA_TRUSTED,
                    CK.DYCKA_FIPS,
                    CK.DYCKA_ENABLED,
            };

    static final int[] intAttrList =
            {
                    CK.CKA_CLASS,
                    CK.CKA_CERTIFICATE_TYPE,
                    CK.CKA_CERTIFICATE_CATEGORY,
                    CK.CKA_KEY_GEN_MECHANISM,
                    CK.CKA_KEY_TYPE,
                    CK.CKA_MODULUS_BITS,
                    CK.CKA_VALUE_LEN,
                    CK.DYCKA_ECDSA_BIP_LEVEL,
                    CK.DYCKA_ECDSA_BIP_CHILD_NUMBER,
                    CK.DYCKA_KEY_ROTATION_INTERVAL,
            };

    public CK_ATTRIBUTE(int type)
    {
        this.type = type;
    }

    public CK_ATTRIBUTE(int type, byte[] value)
    {
        if (isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        if (isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        this.type = type;
        this.value = value;
    }

    public CK_ATTRIBUTE(int type, long value)
    {
        if (isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        if (isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        this.type = type;
        this.value = Utils.uidToBytes(value);
    }

    public CK_ATTRIBUTE(int type, int value)
    {
        if (isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        if (!isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should not be integer");
        this.type = type;
        intValue = value;
    }


    public CK_ATTRIBUTE(int type, boolean value)
    {
        if (isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        if (!isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should not be boolean");
        this.type = type;
        intValue = value ? 1 : 0;
    }

    static boolean isBool(int type)
    {
        for (int t : boolAttrList) if (t==type) return true;
        return false;
    }

    static boolean isInt(int type)
    {
        for (int t : intAttrList) if (t==type) return true;
        return false;
    }

    public int toInt()
    {
        if (isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        if (!isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should not be integer");
        return intValue;
    }

    public boolean toBool()
    {
        if (isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        if (!isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should not be boolean");
        return intValue!=0;
    }

    public byte[] getValue()
    {
        if (isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        if (isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        return value;
    }

    public long toLong()
    {
        if (isBool(type)) throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        if (isInt(type)) throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        if (value.length!=8) return 0;
        return Utils.bytesToUID(value);
    }
}
