package com.dyadicsec.pkcs11;

import java.util.Map;
import static com.dyadicsec.cryptoki.CK.*;

/**
 * Created by valery.osheter on 22-Jun-17.
 */
public abstract class CKPublicKey extends CKKey
{
    static Policy getDefaultPolicy()
    {
        Policy policy = new Policy();
        policy.cka_token = false;
        return policy;
    }

    CKPublicKey() { clazz= CKO_PUBLIC_KEY; }

    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template)
    {
        super.prepareReadTemplate(template);
        addReadTemplate(template, CKA_VERIFY);
        addReadTemplate(template, CKA_ENCRYPT);
        addReadTemplate(template, CKA_WRAP);
        addReadTemplate(template, CKA_TRUSTED);
    }

    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        policy.cka_verify = template.get(CKA_VERIFY).toBool();
        policy.cka_encrypt = template.get(CKA_ENCRYPT).toBool();
        policy.cka_wrap = template.get(CKA_WRAP).toBool();
        policy.cka_trusted = template.get(CKA_TRUSTED).toBool();
        policy.cka_private = policy.cka_sensitive =
                policy.cka_derive = policy.cka_unwrap = policy.cka_sign = policy.cka_decrypt = false;
        policy.cka_extractable = true;
    }

    public CKKey rekey() throws CKException
    {
        throw new CKException("RE-KEY", CKR_FUNCTION_NOT_SUPPORTED);
    }

}
