package com.dyadicsec.pkcs11;

import java.util.Map;
import static com.dyadicsec.cryptoki.CK.*;

/**
 * Created by valery.osheter on 22-Jun-17.
 */
public abstract class CKPrivateKey extends CKKey
{
    CKPrivateKey() { clazz = CKO_PRIVATE_KEY; }

    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template)
    {
        super.prepareReadTemplate(template);
        addReadTemplate(template, CKA_SIGN);
        addReadTemplate(template, CKA_DECRYPT);
        addReadTemplate(template, CKA_UNWRAP);
        addReadTemplate(template, CKA_EXTRACTABLE);
        addReadTemplate(template, CKA_SENSITIVE);
    }

    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        policy.cka_sign = template.get(CKA_SIGN).toBool();
        policy.cka_decrypt = template.get(CKA_DECRYPT).toBool();
        policy.cka_unwrap = template.get(CKA_UNWRAP).toBool();
        policy.cka_extractable = template.get(CKA_EXTRACTABLE).toBool();
        policy.cka_sensitive = template.get(CKA_SENSITIVE).toBool();
        policy.cka_wrap = policy.cka_encrypt = policy.cka_verify = false;
        policy.cka_private = true;
    }

    public CKKey rekey() throws CKException
    {
        throw new CKException("RE-KEY", CKR_FUNCTION_NOT_SUPPORTED);
    }

}
