package com.dyadicsec.pkcs11;

import java.util.ArrayList;
import java.util.Map;
import static com.dyadicsec.cryptoki.CK.*;

/**
 * Created by valery.osheter on 25-Jun-17.
 */
public final class CKPasswordKey extends CKKey
{
    static CK_MECHANISM mech = new CK_MECHANISM(DYCKM_PASSWORD);

    CKPasswordKey()
    {
        keyType = DYCKK_ADV_PASSWORD;
        clazz = CKO_PRIVATE_KEY;
    }

    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        policy.cka_encrypt = policy.cka_verify = policy.cka_private = policy.cka_sensitive = true;
        policy.cka_sign = policy.cka_decrypt = policy.cka_wrap = policy.cka_unwrap = policy.cka_extractable = false;
    }

    public static CKPasswordKey find(Slot slot, String name)
    {
        return (CKPasswordKey) CKObject.find(slot, CKO_PRIVATE_KEY, DYCKK_ADV_PASSWORD, name);
    }

    public static CKPasswordKey find(Slot slot, long uid)
    {
        return CKObject.find(slot, CKPasswordKey.class, uid);
    }

    public static ArrayList<CKPasswordKey> list(Slot slot)
    {
        return CKObject.list(slot, CKPasswordKey.class, CKO_PRIVATE_KEY, DYCKK_ADV_PASSWORD);
    }

    public static CKPasswordKey generate(Slot slot, String name, Policy policy) throws CKException
    {
        CKPasswordKey key = new CKPasswordKey();
        if (policy==null) policy = new Policy();

        CK_ATTRIBUTE[] t =
                {
                        new CK_ATTRIBUTE(CKA_TOKEN, policy.cka_token),
                        new CK_ATTRIBUTE(CKA_CLASS, CKO_PRIVATE_KEY),
                        new CK_ATTRIBUTE(CKA_KEY_TYPE, DYCKK_ADV_PASSWORD),
                        new CK_ATTRIBUTE(CKA_ID, Utils.name2id(name)),
                };

        key.generateKey(slot, DYCKM_PASSWORD_KEY_GEN, t);
        key.policy = policy;
        key.name = name;
        return key;
    }

    public byte[] encrypt(byte[] password) throws CKException
    {
        return encrypt(mech, password, 0);
    }

    public boolean verify(byte[] password, byte[] encrypted) throws CKException
    {
        return verify(mech, password, encrypted);
    }

}
