package com.dyadicsec.pkcs11;

import java.util.Map;
import static com.dyadicsec.cryptoki.CK.*;

/**
 * Created by valery.osheter on 25-Jun-17.
 */
public final class CKLIMAPublicKey extends CKPublicKey
{
    byte[] value = null;

    CKLIMAPublicKey()
    {
        keyType = DYCKK_LIMA;
    }

    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template)
    {
        super.prepareReadTemplate(template);
        addReadTemplate(template, DYCKA_LIMA_PUB_KEY);
    }

    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        value = template.get(DYCKA_LIMA_PUB_KEY).getValue();
    }

    public byte[] getValue() throws CKException
    {
        if (value==null) read();
        return value;
    }

    public static CKLIMAPublicKey create(Slot slot, String name, Policy policy, byte[] value) throws CKException
    {
        if (policy==null) policy = CKPublicKey.getDefaultPolicy();
        CKLIMAPublicKey key = new CKLIMAPublicKey();
        CK_ATTRIBUTE[] t =
                {
                        new CK_ATTRIBUTE(CKA_CLASS,          CKO_PUBLIC_KEY),
                        new CK_ATTRIBUTE(CKA_KEY_TYPE,       DYCKK_LIMA),
                        new CK_ATTRIBUTE(DYCKA_LIMA_PUB_KEY, value),
                        new CK_ATTRIBUTE(CKA_TOKEN,          policy.cka_token),
                        new CK_ATTRIBUTE(CKA_ENCRYPT,        policy.cka_encrypt),
                        new CK_ATTRIBUTE(CKA_WRAP,           policy.cka_wrap),
                };

        key.create(slot, t);
        key.policy = policy;
        key.value = value;
        key.name = name;
        return key;
    }

    public byte[] encrypt(byte[] in) throws CKException
    {
        return encrypt(new CK_MECHANISM(DYCKM_LIMA), in, 0);
    }

}
