package com.dyadicsec.pkcs11;

import java.util.Map;
import static com.dyadicsec.cryptoki.CK.*;

/**
 * Created by valery.osheter on 25-Jun-17.
 */
public final class CKLIMAPrivateKey extends CKPrivateKey
{
    byte[] pubKeyValue = null;
    CKLIMAPublicKey pubKey = null;

    CKLIMAPrivateKey()
    {
        keyType = DYCKK_LIMA;
    }

    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template)
    {
        super.prepareReadTemplate(template);
        addReadTemplate(template, DYCKA_LIMA_PUB_KEY);
    }

    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        pubKeyValue = template.get(DYCKA_LIMA_PUB_KEY).getValue();
    }

    public byte[] getPublicKeyValue() throws CKException
    {
        if (pubKeyValue==null) read();
        return pubKeyValue;
    }

    public CKLIMAPublicKey getPublicKey() throws CKException
    {
        if (pubKey==null) pubKey = CKLIMAPublicKey.create(slot, null, null, getPublicKeyValue());
        return pubKey;
    }

    public static CKLIMAPrivateKey generate(Slot slot, String name, Policy policy) throws CKException
    {
        CKLIMAPrivateKey key = new CKLIMAPrivateKey();
        if (policy==null) policy =  new Policy();

        CK_ATTRIBUTE[] tPrv =
                {
                        new CK_ATTRIBUTE(CKA_TOKEN, policy.cka_token),
                        new CK_ATTRIBUTE(CKA_CLASS, CKO_PRIVATE_KEY),
                        new CK_ATTRIBUTE(CKA_KEY_TYPE, DYCKK_LIMA),
                        new CK_ATTRIBUTE(CKA_SENSITIVE, policy.cka_sensitive),
                        new CK_ATTRIBUTE(CKA_EXTRACTABLE, policy.cka_extractable),
                        new CK_ATTRIBUTE(CKA_DECRYPT, policy.cka_decrypt),
                        new CK_ATTRIBUTE(CKA_UNWRAP, policy.cka_unwrap),
                        new CK_ATTRIBUTE(CKA_ID, Utils.name2id(name)),
                };
        CK_ATTRIBUTE[] tPub =
                {
                        new CK_ATTRIBUTE(CKA_TOKEN, false),
                        new CK_ATTRIBUTE(CKA_CLASS, CKO_PUBLIC_KEY),
                        new CK_ATTRIBUTE(CKA_KEY_TYPE, DYCKK_LIMA),
                };

        key.generateKeyPair(slot, DYCKM_LIMA_KEY_GEN, tPub, tPrv);
        key.policy = policy;
        return key;
    }

    public byte[] decrypt(byte[] in) throws CKException
    {
        return decrypt(new CK_MECHANISM(DYCKM_LIMA), in, 0);
    }

}
