package com.dyadicsec.pkcs11;

import java.util.Map;

import static com.dyadicsec.cryptoki.CK.*;

public final class CKEDDSAPublicKey extends CKPublicKey
{
    byte[] value = null;

    CKEDDSAPublicKey()
    {
        keyType = DYCKK_EDDSA;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template)
    {
        super.prepareReadTemplate(template);
        addReadTemplate(template, DYCKA_EDDSA_PUB_KEY);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        value = template.get(DYCKA_EDDSA_PUB_KEY).getValue();
    }

    public byte[] getValue() throws CKException
    {
        if (value==null) read();
        return value;
    }

    public static CKEDDSAPublicKey create(Slot slot, String name, Policy policy, byte[] value) throws CKException
    {
        if (policy==null) policy = CKPublicKey.getDefaultPolicy();
        CKEDDSAPublicKey key = new CKEDDSAPublicKey();
        CK_ATTRIBUTE[] t =
                {
                        new CK_ATTRIBUTE(CKA_CLASS,             CKO_PUBLIC_KEY),
                        new CK_ATTRIBUTE(CKA_KEY_TYPE,          DYCKK_EDDSA),
                        new CK_ATTRIBUTE(DYCKA_EDDSA_PUB_KEY,   value),
                        new CK_ATTRIBUTE(CKA_TOKEN,             policy.cka_token),
                        new CK_ATTRIBUTE(CKA_VERIFY,            policy.cka_verify),
                };

        key.create(slot, t);
        key.policy = policy;
        key.value = value;
        key.name = name;
        return key;
    }

    public boolean verify(byte[] in, byte[] signature) throws CKException
    {
        return verify(new CK_MECHANISM(DYCKM_EDDSA), in, signature);
    }

}
