package com.dyadicsec.pkcs11;

import java.util.Map;

import static com.dyadicsec.cryptoki.CK.*;

public final class CKEDDSAPrivateKey extends CKPrivateKey
{
    byte[] pubKeyValue = null;
    CKEDDSAPublicKey pubKey = null;

    CKEDDSAPrivateKey()
    {
        keyType = DYCKK_EDDSA;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template)
    {
        super.prepareReadTemplate(template);
        addReadTemplate(template, DYCKA_EDDSA_PUB_KEY);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        pubKeyValue = template.get(DYCKA_EDDSA_PUB_KEY).getValue();
    }

    public byte[] getPublicKeyValue() throws CKException
    {
        if (pubKeyValue==null) read();
        return pubKeyValue;
    }

    public CKEDDSAPublicKey getPublicKey() throws CKException
    {
        if (pubKey==null) pubKey = CKEDDSAPublicKey.create(slot, null, null, getPublicKeyValue());
        return pubKey;
    }

    public static CKEDDSAPrivateKey generate(Slot slot, String name, Policy policy) throws CKException
    {
        CKEDDSAPrivateKey key = new CKEDDSAPrivateKey();
        if (policy==null) policy =  new Policy();

        CK_ATTRIBUTE[] tPrv =
                {
                        new CK_ATTRIBUTE(CKA_TOKEN, policy.cka_token),
                        new CK_ATTRIBUTE(CKA_CLASS, CKO_PRIVATE_KEY),
                        new CK_ATTRIBUTE(CKA_KEY_TYPE, DYCKK_EDDSA),
                        new CK_ATTRIBUTE(CKA_SENSITIVE, policy.cka_sensitive),
                        new CK_ATTRIBUTE(CKA_EXTRACTABLE, policy.cka_extractable),
                        new CK_ATTRIBUTE(CKA_SIGN, policy.cka_sign),
                        new CK_ATTRIBUTE(CKA_ID, Utils.name2id(name)),
                };
        CK_ATTRIBUTE[] tPub =
                {
                        new CK_ATTRIBUTE(CKA_TOKEN, false),
                        new CK_ATTRIBUTE(CKA_CLASS, CKO_PUBLIC_KEY),
                        new CK_ATTRIBUTE(CKA_KEY_TYPE, DYCKK_EDDSA),
                        new CK_ATTRIBUTE(CKA_VERIFY, policy.cka_verify),
                };

        key.generateKeyPair(slot, DYCKM_EDDSA_KEY_GEN, tPub, tPrv);
        key.policy = policy;
        return key;
    }

}
