package com.dyadicsec.pkcs11;

import java.util.ArrayList;
import java.util.Map;
import static com.dyadicsec.cryptoki.CK.*;

/**
 * Created by valery.osheter on 25-Jun-17.
 */
public final class CKData extends CKObject
{
    CKData()
    {
        clazz = CKO_DATA;
    }

    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template)
    {
        super.prepareReadTemplate(template);
        addReadTemplate(template, CKA_PRIVATE);
    }

    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException
    {
        super.saveReadTemplate(template);
        policy.cka_private = template.get(CKA_PRIVATE).toBool();
        policy.cka_extractable = true;
        policy.cka_sensitive = false;
        policy.cka_encrypt = policy.cka_decrypt =
                policy.cka_sign = policy.cka_verify =
                        policy.cka_wrap = policy.cka_unwrap =
                                policy.cka_derive = policy.cka_trusted = false;
    }

    public static CKData create(Slot slot, String name, Policy policy, byte[] value) throws CKException
    {
        CKData data = new CKData();
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]
                {
                        new CK_ATTRIBUTE(CKA_TOKEN, policy.cka_token),
                        new CK_ATTRIBUTE(CKA_PRIVATE, policy.cka_private),
                        new CK_ATTRIBUTE(CKA_CLASS, CKO_DATA),
                        new CK_ATTRIBUTE(CKA_VALUE, value),
                        new CK_ATTRIBUTE(CKA_ID, Utils.name2id(name)),
                };

        data.create(slot, t);
        data.policy = policy;
        data.name = name;
        return data;
    }

    public byte[] getValue() throws CKException
    {
        return getAttributeValue(CKA_VALUE);
    }

    public static CKData find(Slot slot, String name)
    {
        return (CKData) CKObject.find(slot, CKO_DATA, -1, name);
    }

    public static CKData find(Slot slot, long uid)
    {
        return CKObject.find(slot, CKData.class, uid);
    }

    public static ArrayList<CKData> list(Slot slot)
    {
        return CKObject.list(slot, CKData.class, CKO_DATA, -1);
    }


}
