package com.dyadicsec.cryptoki;

public class Native
{
  static public boolean loaded = false;

  static
  {
    try
    {
      System.loadLibrary("ekmpkcs11_jni");
      loaded = true;
    }
    catch (UnsatisfiedLinkError e) { }
  }

  static native long C_GetExtReturnValue();

  static native long C_Initialize();

  static native long C_Finalize();

  static native long C_GetInfo(CK_INFO out);

  static native long C_GetSlotList(boolean tokenPresent, int[] out);

  static native long C_GetSlotInfo(int slotID, CK_SLOT_INFO out);

  static native long C_GetTokenInfo(int slotID, CK_TOKEN_INFO out);

  static native long C_GetMechanismList(int slotID, int[] out);

  static native long C_GetMechanismInfo(int slotID, int type, CK_MECHANISM_INFO out);

  static native long C_OpenSession(int slotID, int flags);

  static native long C_CloseSession(CK_SESSION_HANDLE session, int hSession);

  static native long C_CloseAllSessions(int slotID);

  static native long C_GetSessionInfo(CK_SESSION_HANDLE session, int hSession, CK_SESSION_INFO out);

  static native long C_Login(CK_SESSION_HANDLE session, int hSession, int userType, char[] pPin);

  static native long C_Logout(CK_SESSION_HANDLE session, int hSession);

  static native long C_CreateObject(CK_SESSION_HANDLE session, int hSession, CK_ATTRIBUTE[] pTemplate);

  static native long C_DestroyObject(CK_SESSION_HANDLE session, int hSession, int hObject);

  static native long C_GetAttributeValue(CK_SESSION_HANDLE session, int hSession, int hObject, CK_ATTRIBUTE[]
          pTemplate);

  static native long C_SetAttributeValue(CK_SESSION_HANDLE session, int hSession, int hObject, CK_ATTRIBUTE[]
          pTemplate);

  static native long C_FindObjectsInit(CK_SESSION_HANDLE session, int hSession, CK_ATTRIBUTE[] pTemplate);

  static native long C_FindObjects(CK_SESSION_HANDLE session, int hSession, int[] out);

  static native long C_FindObjectsFinal(CK_SESSION_HANDLE session, int hSession);

  static native long C_EncryptInit(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, int hKey);

  static native long C_Encrypt(CK_SESSION_HANDLE session, int hSession, byte[] pData, int inOffset, int inLen,
                               byte[] out, int outOffset);

  static native long C_EncryptUpdate(CK_SESSION_HANDLE session, int hSession, byte[] pPart, int inOffset, int inLen,
                                     byte[] out, int outOffset);

  static native long C_EncryptFinal(CK_SESSION_HANDLE session, int hSession, byte[] out, int offset);

  static native long C_DecryptInit(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, int hKey);

  static native long C_Decrypt(CK_SESSION_HANDLE session, int hSession, byte[] pEncryptedData, int inOffset,
                               int inLen, byte[] out, int outOffset);

  static native long C_DecryptUpdate(CK_SESSION_HANDLE session, int hSession, byte[] pEncryptedPart, int inOffset,
                                     int inLen, byte[] out, int outOffset);

  static native long C_DecryptFinal(CK_SESSION_HANDLE session, int hSession, byte[] out, int offset);

  static native long C_DigestInit(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism);

  static native long C_Digest(CK_SESSION_HANDLE session, int hSession, byte[] data, int inOffset, int inLen,
                              byte[] out, int outOffset);

  static native long C_DigestUpdate(CK_SESSION_HANDLE session, int hSession, byte[] pPart, int offset, int len);

  static native long C_DigestKey(CK_SESSION_HANDLE session, int hSession, int hObject);

  static native long C_DigestFinal(CK_SESSION_HANDLE session, int hSession, byte[] out, int offset);

  static native long C_SignInit(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, int hKey);

  static native long C_Sign(CK_SESSION_HANDLE session, int hSession, byte[] pData, int inOffset, int inLen,
                            byte[] out, int outOffset);

  static native long C_SignUpdate(CK_SESSION_HANDLE session, int hSession, byte[] pPart, int offset, int inLen);

  static native long C_SignFinal(CK_SESSION_HANDLE session, int hSession, byte[] out, int offset);

  static native long C_VerifyInit(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, int hKey);

  static native long C_Verify(CK_SESSION_HANDLE session, int hSession, byte[] pData, int inOffset, int inLen,
                              byte[] pSignature, int sigOffset, int sigLen);

  static native long C_VerifyUpdate(CK_SESSION_HANDLE session, int hSession, byte[] pPart, int offset, int len);

  static native long C_VerifyFinal(CK_SESSION_HANDLE session, int hSession, byte[] pSignature, int offset, int len);

  static native long C_WrapKey(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, int hWrappingKey,
                               int hKey, byte[] out, int offset);

  static native long C_UnwrapKey(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, int hUnwrappingKey,
                                 byte[] pWrappedKey, int offset, int len, CK_ATTRIBUTE[] pTemplate);

  static native long C_GenerateKey(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[]
          pTemplate);

  static native long C_GenerateKeyPair(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[]
          pPublicKeyTemplate, CK_ATTRIBUTE[] pPrivateKeyTemplate);

  static native long C_DeriveKey(CK_SESSION_HANDLE session, int hSession, CK_MECHANISM pMechanism,
                                 int hBaseKey, CK_ATTRIBUTE[] pTemplate);

  static native long C_SeedRandom(CK_SESSION_HANDLE session, int hSession, byte[] pSeed, int offset, int len);

  static native long C_GenerateRandom(CK_SESSION_HANDLE session, int hSession, byte[] randomData, int offset, int len)
          ;

  static int getResult(long rv, String function) throws CKR_Exception
  {
    CKR_Exception.check(rv, function);
    return (int) (rv & 0xffffffff);
  }

}
