package com.dyadicsec.cryptoki;

import java.util.Arrays;

public class Library
{
    private Library()
    {
    }

    static char[] unpad(char[] in)
    {
        int len = in.length;
        while (len>0 && in[len-1]==0) len--;
        return len==in.length ? in : Arrays.copyOf(in, len);
    }

    public static void C_Initialize() throws CKR_Exception
    {
        CKR_Exception.check(Native.C_Initialize(), "C_Initialize");
    }
    public static void C_Finalize() throws CKR_Exception
    {
        CKR_Exception.check(Native.C_Finalize(), "C_Finalize");
    }

    public static CK_INFO C_GetInfo() throws CKR_Exception
    {
        CK_INFO out = new CK_INFO();
        CKR_Exception.check(Native.C_GetInfo(out), "C_GetInfo");
        out.unpad();
        return out;
    }

    public static int[] C_GetSlotList(boolean tokenPresent) throws CKR_Exception
    {
        int count = Native.getResult(Native.C_GetSlotList(tokenPresent, null), "C_GetSlotList(null)");
        int[] out = new int[count];
        CKR_Exception.check(Native.C_GetSlotList(tokenPresent, out), "C_GetSlotList");
        return out;
    }

    public static CK_SLOT_INFO C_GetSlotInfo(int slotID) throws CKR_Exception
    {
        CK_SLOT_INFO out = new CK_SLOT_INFO();
        CKR_Exception.check(Native.C_GetSlotInfo(slotID, out), "C_GetSlotInfo");
        out.unpad();
        return out;
    }

    public static CK_TOKEN_INFO C_GetTokenInfo(int slotID) throws CKR_Exception
    {
        CK_TOKEN_INFO out = new CK_TOKEN_INFO();
        CKR_Exception.check(Native.C_GetTokenInfo(slotID, out), "C_GetTokenInfo");
        out.unpad();
        return out;
    }

    public static int[] C_GetMechanismList(int slotID) throws CKR_Exception
    {
        int count = Native.getResult(Native.C_GetMechanismList(slotID, null), "C_GetMechanismList(null)");
        int[] out = new int[count];
        CKR_Exception.check(Native.C_GetMechanismList(slotID, out), "C_GetMechanismList");
        return out;
    }

    public static CK_MECHANISM_INFO C_GetMechanismInfo(int slotID, int type) throws CKR_Exception
    {
        CK_MECHANISM_INFO out = new CK_MECHANISM_INFO();
        CKR_Exception.check(Native.C_GetMechanismInfo(slotID, type, out), "C_GetMechanismInfo (" + Integer.toHexString(type) + ")");
        return out;
    }

    public static CK_SESSION_HANDLE C_OpenSession(int slotID, int flags) throws CKR_Exception
    {
        int h = Native.getResult(Native.C_OpenSession(slotID, flags), "C_OpenSession (" + slotID + ")");
        CK_SESSION_HANDLE out = new CK_SESSION_HANDLE();
        out.h = h;
        return out;
    }

    public static void C_CloseSession(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_CloseSession(hSession, hSession.h), "C_OpenSession");
    }

    public static void C_CloseAllSessions(int slotID) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_CloseAllSessions(slotID), "C_CloseAllSessions");
    }

    public static CK_SESSION_INFO C_GetSessionInfo(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        CK_SESSION_INFO out = new CK_SESSION_INFO();
        CKR_Exception.check(Native.C_GetSessionInfo(hSession, hSession.h, out), "C_GetSessionInfo");
        return out;
    }

    public static void C_Login(CK_SESSION_HANDLE hSession, int userType, char[] pPin) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_Login(hSession, hSession.h, userType, pPin), "C_Login");
    }

    public static void C_Logout(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_Logout(hSession, hSession.h), "C_Logout");
    }

    public static int C_CreateObject(CK_SESSION_HANDLE hSession, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        CK_ATTRIBUTE.toNative(pTemplate);
        return Native.getResult(Native.C_CreateObject(hSession, hSession.h, pTemplate), "C_CreateObject");
    }

    public static void C_DestroyObject(CK_SESSION_HANDLE hSession, int hObject) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_DestroyObject(hSession, hSession.h, hObject), "C_DestroyObject");
    }

    public static void C_GetAttributeValue(CK_SESSION_HANDLE hSession, int hObject, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        if (!CK_ATTRIBUTE.allKnownSizes(pTemplate))
        {
            CK_ATTRIBUTE.toNativeGetSize(pTemplate);
            CKR_Exception.check(Native.C_GetAttributeValue(hSession, hSession.h, hObject, pTemplate), "C_GetAttributeValue(null)");
        }
        CK_ATTRIBUTE.toNativeGetValue(pTemplate);
        CKR_Exception.check(Native.C_GetAttributeValue(hSession, hSession.h, hObject, pTemplate), "C_GetAttributeValue");
        CK_ATTRIBUTE.fromNative(pTemplate);
    }

    public static void C_SetAttributeValue(CK_SESSION_HANDLE hSession, int hObject, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        CK_ATTRIBUTE.toNative(pTemplate);
        CKR_Exception.check(Native.C_SetAttributeValue(hSession, hSession.h, hObject, pTemplate), "C_SetAttributeValue");
    }

    public static void C_FindObjectsInit(CK_SESSION_HANDLE hSession, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        CK_ATTRIBUTE.toNative(pTemplate);
        CKR_Exception.check(Native.C_FindObjectsInit(hSession, hSession.h, pTemplate), "C_FindObjectsInit");
    }

    public static int[] C_FindObjects(CK_SESSION_HANDLE hSession, int ulMaxObjectCount)  throws CKR_Exception
    {
        int[] out = new int[ulMaxObjectCount];
        int count = Native.getResult(Native.C_FindObjects(hSession, hSession.h, out), "C_FindObjects");
        return count==out.length ? out : Arrays.copyOf(out, count);
    }

    public static void C_FindObjectsFinal(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_FindObjectsFinal(hSession, hSession.h), "C_FindObjectsFinal");
    }

    public static void C_EncryptInit(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hKey) throws CKR_Exception
    {
        pMechanism.toNative();
        CKR_Exception.check(Native.C_EncryptInit(hSession, hSession.h, pMechanism, hKey), "C_EncryptInit");
    }

    public static int C_Encrypt(CK_SESSION_HANDLE hSession, byte[] pData, int inOffset, int inLen, byte[] out, int outOffset) throws CKR_Exception
    {
        return Native.getResult(Native.C_Encrypt(hSession, hSession.h, pData, inOffset, inLen, out, outOffset), "C_Encrypt");
    }

    public static byte[] C_Encrypt(CK_SESSION_HANDLE hSession, byte[] pData) throws CKR_Exception
    {
        int len = C_Encrypt(hSession, pData, 0, pData.length, null, 0);
        byte[] out = new byte[len];
        len = C_Encrypt(hSession, pData, 0, pData.length, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static int C_EncryptUpdate(CK_SESSION_HANDLE hSession, byte[] pPart, int inOffset, int inLen, byte[] out, int outOffset) throws CKR_Exception
    {
        return Native.getResult(Native.C_EncryptUpdate(hSession, hSession.h, pPart, inOffset, inLen, out, outOffset), "C_EncryptUpdate");
    }

    public static byte[] C_EncryptUpdate(CK_SESSION_HANDLE hSession, byte[] pPart) throws CKR_Exception
    {
        int len = C_EncryptUpdate(hSession, pPart, 0, pPart.length, null, 0);
        byte[] out = new byte[len];
        len = C_EncryptUpdate(hSession, pPart, 0, pPart.length, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static int C_EncryptFinal(CK_SESSION_HANDLE hSession, byte[] out, int offset) throws CKR_Exception
    {
        return Native.getResult(Native.C_EncryptFinal(hSession, hSession.h, out, offset), "C_EncryptFinal");
    }

    public static byte[] C_EncryptFinal(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        int len = C_EncryptFinal(hSession, null, 0);
        byte[] out = new byte[len];
        len = C_EncryptFinal(hSession, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static void C_DecryptInit(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hKey) throws CKR_Exception
    {
        pMechanism.toNative();
        CKR_Exception.check(Native.C_DecryptInit(hSession, hSession.h, pMechanism, hKey), "C_DecryptInit");
    }

    public static int C_Decrypt(CK_SESSION_HANDLE hSession, byte[] pEncryptedData, int inOffset, int inLen, byte[] out, int outOffset) throws CKR_Exception
    {
        return Native.getResult(Native.C_Decrypt(hSession, hSession.h, pEncryptedData, inOffset, inLen, out, outOffset), "C_Decrypt");
    }

    public static byte[] C_Decrypt(CK_SESSION_HANDLE hSession, byte[] pEncryptedData) throws CKR_Exception
    {
        int len = C_Decrypt(hSession, pEncryptedData, 0, pEncryptedData.length, null, 0);
        byte[] out = new byte[len];
        len = C_Decrypt(hSession, pEncryptedData, 0, pEncryptedData.length, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static int C_DecryptUpdate(CK_SESSION_HANDLE hSession, byte[] pEncryptedPart, int inOffset, int inLen, byte[] out, int outOffset) throws CKR_Exception
    {
        return Native.getResult(Native.C_DecryptUpdate(hSession, hSession.h, pEncryptedPart, inOffset, inLen, out, outOffset), "C_DecryptUpdate");
    }

    public static byte[] C_DecryptUpdate(CK_SESSION_HANDLE hSession, byte[] pEncryptedPart) throws CKR_Exception
    {
        int len = C_DecryptUpdate(hSession, pEncryptedPart, 0, pEncryptedPart.length, null, 0);
        byte[] out = new byte[len];
        len = C_DecryptUpdate(hSession, pEncryptedPart, 0, pEncryptedPart.length, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static int C_DecryptFinal(CK_SESSION_HANDLE hSession, byte[] out, int offset) throws CKR_Exception
    {
        return Native.getResult(Native.C_DecryptFinal(hSession, hSession.h, out, offset), "C_DecryptFinal");
    }

    public static byte[] C_DecryptFinal(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        int len = C_DecryptFinal(hSession, null, 0);
        byte[] out = new byte[len];
        len = C_DecryptFinal(hSession, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static void C_DigestInit(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism) throws CKR_Exception
    {
        pMechanism.toNative();
        CKR_Exception.check(Native.C_DigestInit(hSession, hSession.h, pMechanism), "C_DigestInit");
    }

    public static int C_Digest(CK_SESSION_HANDLE hSession, byte[] data, int inOffset, int inLen, byte[] out, int outOffset)  throws CKR_Exception
    {
        return Native.getResult(Native.C_Digest(hSession, hSession.h, data, inOffset, inLen, out, outOffset), "C_Digest");
    }

    public static byte[] C_Digest(CK_SESSION_HANDLE hSession, byte[] data)  throws CKR_Exception
    {
        int len = C_Digest(hSession, data, 0, data.length, null, 0);
        byte[] out = new byte[len];
        len = C_Digest(hSession, data, 0, data.length, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static void C_DigestUpdate(CK_SESSION_HANDLE hSession, byte[] pPart, int offset, int len) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_DigestUpdate(hSession, hSession.h, pPart, offset, len), "C_DigestUpdate");
    }

    public static void C_DigestUpdate(CK_SESSION_HANDLE hSession, byte[] pPart) throws CKR_Exception
    {
        C_DigestUpdate(hSession, pPart, 0, pPart.length);
    }

    public static void C_DigestKey(CK_SESSION_HANDLE hSession, int hObject) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_DigestKey(hSession, hSession.h, hObject), "C_DigestKey");
    }

    public static int C_DigestFinal(CK_SESSION_HANDLE hSession, byte[] out, int offset) throws CKR_Exception
    {
        return Native.getResult(Native.C_DigestFinal(hSession, hSession.h, out, offset), "C_DigestFinal");
    }

    public static byte[] C_DigestFinal(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        int len = C_DigestFinal(hSession, null, 0);
        byte[] out = new byte[len];
        len = C_DigestFinal(hSession, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static void C_SignInit(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hKey) throws CKR_Exception
    {
        pMechanism.toNative();
        CKR_Exception.check(Native.C_SignInit(hSession, hSession.h, pMechanism, hKey), "C_SignInit");
    }

    public static int C_Sign(CK_SESSION_HANDLE hSession, byte[] pData, int inOffset, int inLen, byte[] out, int outOffset) throws CKR_Exception
    {
        return Native.getResult(Native.C_Sign(hSession, hSession.h, pData, inOffset, inLen, out, outOffset), "C_Sign");
    }

    public static byte[] C_Sign(CK_SESSION_HANDLE hSession, byte[] pData) throws CKR_Exception
    {
        int len = C_Sign(hSession, pData, 0, pData.length, null, 0);
        byte[] out = new byte[len];
        len = C_Sign(hSession, pData, 0, pData.length, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static void C_SignUpdate(CK_SESSION_HANDLE hSession, byte[] pPart, int offset, int len) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_SignUpdate(hSession, hSession.h, pPart, offset, len), "C_SignUpdate");
    }

    public static void C_SignUpdate(CK_SESSION_HANDLE hSession, byte[] pPart) throws CKR_Exception
    {
        C_SignUpdate(hSession, pPart, 0, pPart.length);
    }

    public static int C_SignFinal(CK_SESSION_HANDLE hSession, byte[] out, int offset) throws CKR_Exception
    {
        return Native.getResult(Native.C_SignFinal(hSession, hSession.h, out, offset), "C_SignFinal");
    }

    public static byte[] C_SignFinal(CK_SESSION_HANDLE hSession) throws CKR_Exception
    {
        int len = C_SignFinal(hSession, null, 0);
        byte[] out = new byte[len];
        len = C_SignFinal(hSession, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static void C_VerifyInit(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hKey) throws CKR_Exception
    {
        pMechanism.toNative();
        CKR_Exception.check(Native.C_VerifyInit(hSession, hSession.h, pMechanism, hKey), "C_VerifyInit");
    }

    public static void C_Verify(CK_SESSION_HANDLE hSession, byte[] pData, int inOffset, int inLen, byte[] pSignature, int sigOffset, int sigLen) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_Verify(hSession, hSession.h, pData, inOffset, inLen, pSignature, sigOffset, sigLen), "C_Verify");
    }

    public static void C_Verify(CK_SESSION_HANDLE hSession, byte[] pData, byte[] pSignature) throws CKR_Exception
    {
        C_Verify(hSession, pData, 0, pData.length, pSignature, 0, pSignature.length);
    }

    public static void C_VerifyUpdate(CK_SESSION_HANDLE hSession, byte[] pPart, int offset, int len) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_VerifyUpdate(hSession, hSession.h, pPart, offset, pPart.length), "C_VerifyUpdate");
    }

    public static void C_VerifyUpdate(CK_SESSION_HANDLE hSession, byte[] pPart) throws CKR_Exception
    {
        C_VerifyUpdate(hSession, pPart, 0, pPart.length);
    }

    public static void C_VerifyFinal(CK_SESSION_HANDLE hSession, byte[] pSignature, int offset, int len) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_VerifyFinal(hSession, hSession.h, pSignature, offset, len), "C_VerifyFinal");
    }

    public static void C_VerifyFinal(CK_SESSION_HANDLE hSession, byte[] pSignature) throws CKR_Exception
    {
        C_VerifyFinal(hSession, pSignature, 0, pSignature.length);
    }

    public static int C_GenerateKey(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        pMechanism.toNative();
        CK_ATTRIBUTE.toNative(pTemplate);
        return Native.getResult(Native.C_GenerateKey(hSession, hSession.h, pMechanism, pTemplate), "C_GenerateKey");
    }

    public static int[] C_GenerateKeyPair(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pPublicKeyTemplate, CK_ATTRIBUTE[] pPrivateKeyTemplate) throws CKR_Exception
    {
        pMechanism.toNative();
        CK_ATTRIBUTE.toNative(pPublicKeyTemplate);
        CK_ATTRIBUTE.toNative(pPrivateKeyTemplate);
        int hPrv = Native.getResult(Native.C_GenerateKeyPair(hSession, hSession.h, pMechanism, pPublicKeyTemplate, pPrivateKeyTemplate), "C_GenerateKeyPair");
        int hPub = Native.getResult(Native.C_GetExtReturnValue(), "C_GenerateKeyPair");
        int[] out = new int[2]; out[0] = hPub; out[1] = hPrv;
        return out;
    }

    public static int C_WrapKey(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hWrappingKey, int hKey, byte[] out, int offset) throws CKR_Exception
    {
        pMechanism.toNative();
        return Native.getResult(Native.C_WrapKey(hSession, hSession.h, pMechanism, hWrappingKey, hKey, out, offset), "C_WrapKey");
    }

    public static byte[] C_WrapKey(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hWrappingKey, int hKey) throws CKR_Exception
    {
        int len = C_WrapKey(hSession, pMechanism, hWrappingKey, hKey, null, 0);
        byte[] out = new byte[len];
        len = C_WrapKey(hSession, pMechanism, hWrappingKey, hKey, out, 0);
        return len==out.length ? out : Arrays.copyOf(out, len);
    }

    public static int C_UnwrapKey(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hUnwrappingKey, byte[] pWrappedKey, int offset, int len, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        pMechanism.toNative();
        CK_ATTRIBUTE.toNative(pTemplate);
        return Native.getResult(Native.C_UnwrapKey(hSession, hSession.h, pMechanism, hUnwrappingKey, pWrappedKey, offset, len, pTemplate),"C_UnwrapKey");
    }

    public static int C_UnwrapKey(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hUnwrappingKey,  byte[] pWrappedKey, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        return C_UnwrapKey(hSession, pMechanism, hUnwrappingKey, pWrappedKey, 0, pWrappedKey.length, pTemplate);
    }

    public static int C_DeriveKey(CK_SESSION_HANDLE hSession, CK_MECHANISM pMechanism, int hBaseKey, CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        pMechanism.toNative();
        CK_ATTRIBUTE.toNative(pTemplate);
        return Native.getResult(Native.C_DeriveKey(hSession, hSession.h, pMechanism, hBaseKey, pTemplate),"C_DeriveKey");
    }

    public static void C_SeedRandom(CK_SESSION_HANDLE hSession, byte[] pSeed, int offset, int len) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_SeedRandom(hSession, hSession.h, pSeed, offset, len), "C_SeedRandom");
    }

    public static void C_SeedRandom(CK_SESSION_HANDLE hSession, byte[] pSeed) throws CKR_Exception
    {
        C_SeedRandom(hSession, pSeed, 0, pSeed.length);
    }

    public static void C_GenerateRandom(CK_SESSION_HANDLE hSession, byte[] randomData, int offset, int len) throws CKR_Exception
    {
        CKR_Exception.check(Native.C_GenerateRandom(hSession, hSession.h, randomData, offset, len), "C_GenerateRandom");
    }

    public static byte[] C_GenerateRandom(CK_SESSION_HANDLE hSession, int len) throws CKR_Exception
    {
        byte[] out = new byte[len];
        C_GenerateRandom(hSession, out, 0, len);
        return out;
    }

}
