package com.dyadicsec.cryptoki;

import java.io.UnsupportedEncodingException;

public class CK_MECHANISM
{
    public int mechanism;
    public java.lang.Object pParameter;

    public CK_MECHANISM(int mechanism, java.lang.Object pParameter)
    {
        this.mechanism = mechanism;
        this.pParameter = pParameter;
    }

    public CK_MECHANISM(int mechanism)
    {
        this.mechanism = mechanism;
        this.pParameter = null;
    }

/*
  public static final CK_MECHANISM CKM_RSA_PKCS_KEY_PAIR_GEN = new CK_MECHANISM(CK.CKM_RSA_PKCS_KEY_PAIR_GEN);
  public static final CK_MECHANISM CKM_RSA_X_509 = new CK_MECHANISM(CK.CKM_RSA_X_509);
  public static final CK_MECHANISM CKM_RSA_PKCS = new CK_MECHANISM(CK.CKM_RSA_PKCS);
  public static final CK_MECHANISM CKM_SHA256_RSA_PKCS = new CK_MECHANISM(CK.CKM_SHA256_RSA_PKCS);
  public static final CK_MECHANISM CKM_SHA384_RSA_PKCS = new CK_MECHANISM(CK.CKM_SHA384_RSA_PKCS);
  public static final CK_MECHANISM CKM_SHA512_RSA_PKCS = new CK_MECHANISM(CK.CKM_SHA512_RSA_PKCS);

  public static final CK_MECHANISM CKM_EC_KEY_PAIR_GEN = new CK_MECHANISM(CK.CKM_EC_KEY_PAIR_GEN);
  public static final CK_MECHANISM CKM_ECDSA_SHA1 = new CK_MECHANISM(CK.CKM_ECDSA_SHA1);

  public static final CK_MECHANISM CKM_AES_KEY_GEN = new CK_MECHANISM(CK.CKM_AES_KEY_GEN);
  public static final CK_MECHANISM CKM_AES_ECB = new CK_MECHANISM(CK.CKM_AES_ECB);

  public static final CK_MECHANISM CKM_DES3_KEY_GEN = new CK_MECHANISM(CK.CKM_DES3_KEY_GEN);
  public static final CK_MECHANISM CKM_DES3_ECB = new CK_MECHANISM(CK.CKM_DES3_ECB);

  public static final CK_MECHANISM CKM_GENERIC_SECRET_KEY_GEN = new CK_MECHANISM(CK.CKM_GENERIC_SECRET_KEY_GEN);
  public static final CK_MECHANISM CKM_SHA_1_HMAC = new CK_MECHANISM(CK.CKM_SHA_1_HMAC);
  public static final CK_MECHANISM CKM_SHA256_HMAC = new CK_MECHANISM(CK.CKM_SHA256_HMAC);
  public static final CK_MECHANISM CKM_SHA384_HMAC = new CK_MECHANISM(CK.CKM_SHA384_HMAC);
  public static final CK_MECHANISM CKM_SHA512_HMAC = new CK_MECHANISM(CK.CKM_SHA512_HMAC);
  public static final CK_MECHANISM CKM_SHA1_RSA_PKCS = new CK_MECHANISM(CK.CKM_SHA1_RSA_PKCS);

  public static final CK_MECHANISM CKM_SHA_1 = new CK_MECHANISM(CK.CKM_SHA_1);
  public static final CK_MECHANISM CKM_SHA256 = new CK_MECHANISM(CK.CKM_SHA256);
  public static final CK_MECHANISM CKM_SHA384 = new CK_MECHANISM(CK.CKM_SHA384);
  public static final CK_MECHANISM CKM_SHA512 = new CK_MECHANISM(CK.CKM_SHA512);
*/

    void toNative() throws CKR_Exception
    {
        switch (mechanism)
        {
            case CK.CKM_RSA_PKCS_KEY_PAIR_GEN:
            case CK.CKM_RSA_PKCS:
            case CK.CKM_RSA_X_509:
            case CK.CKM_SHA1_RSA_PKCS:
            case CK.CKM_SHA256_RSA_PKCS:
            case CK.CKM_SHA384_RSA_PKCS:
            case CK.CKM_SHA512_RSA_PKCS:
            case CK.CKM_SHA_1:
            case CK.CKM_SHA256:
            case CK.CKM_SHA384:
            case CK.CKM_SHA512:
            case CK.CKM_EC_KEY_PAIR_GEN:
            case CK.CKM_ECDSA:
            case CK.CKM_ECDSA_SHA1:
            case CK.CKM_ECDSA_SHA256:
            case CK.CKM_ECDSA_SHA384:
            case CK.CKM_ECDSA_SHA512:
            case CK.CKM_AES_KEY_GEN:
            case CK.CKM_DES3_ECB:
            case CK.CKM_AES_ECB:
            case CK.DYCKM_AES_XTS_KEY_GEN:
            case CK.DYCKM_AES_SIV_KEY_GEN:
            case CK.CKM_DES3_KEY_GEN:
            case CK.CKM_GENERIC_SECRET_KEY_GEN:
            case CK.CKM_SHA_1_HMAC:
            case CK.CKM_SHA256_HMAC:
            case CK.CKM_SHA384_HMAC:
            case CK.CKM_SHA512_HMAC:
            case CK.CKM_SHA1_KEY_DERIVATION:
            case CK.CKM_SHA256_KEY_DERIVATION:
            case CK.CKM_SHA384_KEY_DERIVATION:
            case CK.CKM_SHA512_KEY_DERIVATION:
            case CK.DYCKM_LIMA_KEY_GEN:
            case CK.DYCKM_LIMA:
            case CK.DYCKM_PASSWORD_KEY_GEN:
            case CK.DYCKM_PRF_KEY_GEN:
            case CK.DYCKM_PASSWORD:
            case CK.DYCKM_OPE:
                if (pParameter!=null) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_AES_GMAC:
            case CK.CKM_AES_CBC_PAD:
            case CK.CKM_AES_CBC:
            case CK.CKM_DES3_CBC:
            case CK.CKM_AES_OFB:
            case CK.CKM_AES_CFB128:
            case CK.DYCKM_AES_XTS:
            case CK.CKM_DES3_CBC_PAD:
            case CK.CKM_DES_CFB64:
            case CK.CKM_DES_OFB64:
            case CK.CKM_DES3_CMAC:
                if (!(pParameter instanceof byte[])) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_SHA_1_HMAC_GENERAL:
            case CK.CKM_SHA256_HMAC_GENERAL:
            case CK.CKM_SHA384_HMAC_GENERAL:
            case CK.CKM_SHA512_HMAC_GENERAL:
            case CK.CKM_AES_CMAC:
                if (!(pParameter instanceof Integer)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_AES_KEY_WRAP:
            case CK.CKM_AES_KEY_WRAP_PAD:
                if (pParameter!=null && !(pParameter instanceof byte[])) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_RSA_PKCS_OAEP:
                if (!(pParameter instanceof CK_RSA_PKCS_OAEP_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_RSA_PKCS_PSS:
            case CK.CKM_SHA1_RSA_PKCS_PSS:
            case CK.CKM_SHA256_RSA_PKCS_PSS:
            case CK.CKM_SHA384_RSA_PKCS_PSS:
            case CK.CKM_SHA512_RSA_PKCS_PSS:
                if (!(pParameter instanceof CK_RSA_PKCS_PSS_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_ECDH1_DERIVE:
                if (!(pParameter instanceof CK_ECDH1_DERIVE_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_CONCATENATE_DATA_AND_BASE:
            case CK.CKM_CONCATENATE_BASE_AND_DATA:
                if (!(pParameter instanceof CK_KEY_DERIVATION_STRING_DATA)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_AES_CCM:
                if (!(pParameter instanceof CK_CCM_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_AES_GCM:
                if (!(pParameter instanceof CK_GCM_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.CKM_AES_CTR:
                if (!(pParameter instanceof CK_AES_CTR_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.DYCKM_AES_SIV:
                if (!(pParameter instanceof DYCK_AES_SIV_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.DYCKM_PRF:
                if (!(pParameter instanceof DYCK_PRF_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.DYCKM_FPE:
                if (!(pParameter instanceof DYCK_FPE_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.DYCKM_SPE:
                if (!(pParameter instanceof DYCK_SPE_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.DYCKM_DERIVE_ECDSA_BIP:
                if ((pParameter!=null) && !(pParameter instanceof DYCK_DERIVE_ECDSA_BIP_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;

            case CK.DYCKM_NIST_KDF_CMAC_CTR:
                if (!(pParameter instanceof DYCK_NIST_KDF_CMAC_CTR_PARAMS)) throw new CKR_Exception(CK.CKR_MECHANISM_PARAM_INVALID);
                break;
        }
    }
}
