package com.dyadicsec.cryptoki;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public class CK_ATTRIBUTE
{
    public int type;
    public java.lang.Object pValue;

    // native
    private int size;
    private long longValue;
    private byte [] bufValue;

    public CK_ATTRIBUTE(int type)
    {
        this.type = type;
    }

    public CK_ATTRIBUTE(int type, java.lang.Object value)  throws CKR_Exception
    {
        this.type = type;
        this.pValue = value;
    }

    public CK_ATTRIBUTE(int type, boolean value)  throws CKR_Exception
    {
        int mode = getAttrMode(type);
        if (mode != attr_bool) throw new CKR_Exception(CK.CKR_ATTRIBUTE_VALUE_INVALID);
        this.type = type;
        longValue = value ? 1 : 0;
    }

    public CK_ATTRIBUTE(int type, int value)  throws CKR_Exception
    {
        int mode = getAttrMode(type);
        if (mode != attr_int) throw new CKR_Exception(CK.CKR_ATTRIBUTE_VALUE_INVALID);
        this.type = type;
        longValue = (long)value;
    }

    public CK_ATTRIBUTE(int type, long value)  throws CKR_Exception
    {
        int mode = getAttrMode(type);
        if (mode != attr_long) throw new CKR_Exception(CK.CKR_ATTRIBUTE_VALUE_INVALID);
        this.type = type;
        longValue = (long)value;
    }

    public boolean getBooleanValue()  throws CKR_Exception
    {
        return longValue!=0;
    }

    public int getIntValue()  throws CKR_Exception
    {
        return (int)longValue;
    }

    public long getLongValue()  throws CKR_Exception
    {
        return longValue;
    }

    private static final int attr_bytes = 0;
    private static final int attr_bool = 1;
    private static final int attr_int = 2;
    private static final int attr_bigint = 3;
    private static final int attr_str = 4;
    private static final int attr_date = 5;
    private static final int attr_long = 6;

    private static int getAttrMode(int attr)
    {
        switch(attr)
        {
            case CK.DYCKA_UID:
            case CK.KMIP_REPLACED_UID:
            case CK.DYCKA_ECDSA_BIP_PARENT_UID:
            case CK.DYCKA_NEXT_KEY_ROTATION_TIME:
                return attr_long;

            case CK.CKA_TOKEN:
            case CK.CKA_PRIVATE:
            case CK.CKA_MODIFIABLE:
            case CK.CKA_DERIVE:
            case CK.CKA_LOCAL:
            case CK.CKA_ENCRYPT:
            case CK.CKA_VERIFY:
            case CK.CKA_VERIFY_RECOVER:
            case CK.CKA_WRAP:
            case CK.CKA_SENSITIVE:
            case CK.CKA_SECONDARY_AUTH:
            case CK.CKA_DECRYPT:
            case CK.CKA_SIGN:
            case CK.CKA_SIGN_RECOVER:
            case CK.CKA_UNWRAP:
            case CK.CKA_EXTRACTABLE:
            case CK.CKA_ALWAYS_SENSITIVE:
            case CK.CKA_NEVER_EXTRACTABLE:
            case CK.CKA_TRUSTED:
            case CK.CKA_WRAP_WITH_TRUSTED:
            case CK.CKA_ALWAYS_AUTHENTICATE:
            case CK.DYCKA_FIPS:
            case CK.DYCKA_ENABLED:
                return attr_bool;

            case CK.CKA_CLASS:
            case CK.CKA_KEY_TYPE:
            case CK.CKA_CERTIFICATE_TYPE:
            case CK.CKA_MODULUS_BITS:
            case CK.CKA_VALUE_BITS:
            case CK.CKA_VALUE_LEN:
            case CK.CKA_KEY_GEN_MECHANISM:
            case CK.CKA_CERTIFICATE_CATEGORY:
            case CK.DYCKA_ECDSA_BIP_LEVEL:
            case CK.DYCKA_ECDSA_BIP_CHILD_NUMBER:
            case CK.DYCKA_ECDSA_BIP_PARENT_FINGERPRINT:
            case CK.DYCKA_KEY_ROTATION_INTERVAL:
                return attr_int;

            case CK.CKA_START_DATE:
            case CK.CKA_END_DATE:
                return attr_date;

            case CK.CKA_PUBLIC_EXPONENT:
            case CK.CKA_PRIVATE_EXPONENT:
            case CK.CKA_PRIME_1:
            case CK.CKA_PRIME_2:
            case CK.CKA_EXPONENT_1:
            case CK.CKA_EXPONENT_2:
            case CK.CKA_COEFFICIENT:
            case CK.CKA_MODULUS:
                return attr_bigint;

            case CK.CKA_LABEL:
                return attr_str;
        }
        return attr_bytes;
    }

    private boolean knownSize()
    {
        int mode = getAttrMode(type);
        return mode == attr_bool || mode == attr_int || mode == attr_long;
    }

    private void toNativeGetSize()
    {
        bufValue = null;
    }

    private void toNativeGetValue()
    {
        if (!knownSize()) bufValue = new byte[size];
    }

    private void toNative() throws CKR_Exception
    {
        size = 0;
        bufValue = null;

        if (pValue==null) return;
        boolean ok = true;

        try {

            int mode = getAttrMode(type);
            switch (mode)
            {
                case attr_bool:
                    if (pValue instanceof Boolean) longValue = ((Boolean)pValue).booleanValue() ? 1 : 0;
                    else ok = false;
                    break;

                case attr_int:
                    if (pValue instanceof Byte)         longValue = ((Byte)pValue).byteValue() & 0xff;
                    else if (pValue instanceof Short)   longValue = ((Short)pValue).shortValue() & 0xffff;
                    else if (pValue instanceof Integer) longValue = ((Integer)pValue).intValue();
                    else if (pValue instanceof Long)
                    {
                        long x = ((Long)pValue).longValue();
                        if ((x & 0xffffffff00000000L) == 0L) longValue = (int)(x & 0xffffffff);
                        else ok = false;
                    }
                    else ok = false;
                    break;

                case attr_long:
                    if (pValue instanceof Long) longValue = ((Long)pValue).longValue();
                    else ok = false;
                    break;

                case attr_bigint:
                    if (pValue instanceof BigInteger)
                    {
                        bufValue = ((BigInteger)pValue).toByteArray();
                        if (bufValue!=null && bufValue.length>0 && bufValue[0]==0) bufValue = Arrays.copyOfRange(bufValue, 1, bufValue.length);
                    }
                    else if (pValue instanceof byte[]) bufValue = (byte[])pValue;
                    else ok = false;
                    break;

                case attr_str:
                    if (pValue instanceof String) bufValue = ((String) pValue).getBytes("UTF-8");
                    else if (pValue instanceof char[]) bufValue = new String((char[]) pValue).getBytes("UTF-8");
                    else if (pValue instanceof byte[]) bufValue = (byte[])pValue;
                    else ok = false;
                    break;

                case attr_date:
                    if (pValue instanceof CK_DATE)
                    {
                        CK_DATE d = (CK_DATE)pValue;
                        bufValue = new byte[8];
                        bufValue[0] = (byte)d.year[0];
                        bufValue[1] = (byte)d.year[1];
                        bufValue[2] = (byte)d.year[2];
                        bufValue[3] = (byte)d.year[3];
                        bufValue[4] = (byte)d.month[0];
                        bufValue[5] = (byte)d.month[1];
                        bufValue[6] = (byte)d.day[0];
                        bufValue[7] = (byte)d.day[1];
                    }
                    else if (pValue instanceof byte[])
                    {
                        bufValue = (byte[])pValue;
                        if (bufValue.length != 8) ok = false;
                    }
                    else ok = false;
                    break;

                default:
                    if (pValue instanceof byte[]) bufValue = (byte[])pValue;
                    else ok = false;
            }
        }
        catch (UnsupportedEncodingException e) { ok = false; }

        if (!ok) throw new CKR_Exception(CK.CKR_ATTRIBUTE_VALUE_INVALID);
        if (bufValue!=null) size = bufValue.length;
    }

    private void fromNative() throws CKR_Exception
    {
        int mode = getAttrMode(type);
        switch (mode)
        {
            case attr_bool:
                if (pValue==null) return;
                pValue = new Boolean(longValue != 0);
                break;

            case attr_int:
                if (pValue==null) return;
                pValue = new Integer((int)longValue);
                break;

            case attr_long:
                if (pValue==null) return;
                pValue = new Long(longValue);
                break;

            case attr_bigint:
                pValue = new BigInteger(1, bufValue);
                break;

            case attr_str:
                try { pValue = new String(bufValue, "UTF-8"); }
                catch (UnsupportedEncodingException e) { throw new CKR_Exception(CK.CKR_ATTRIBUTE_VALUE_INVALID, e); }
                break;

            case attr_date:
                CK_DATE d = new CK_DATE();
                d.year[0]  = (char)bufValue[0];
                d.year[1]  = (char)bufValue[1];
                d.year[2]  = (char)bufValue[2];
                d.year[3]  = (char)bufValue[3];
                d.month[0] = (char)bufValue[4];
                d.month[1] = (char)bufValue[5];
                d.day[0]   = (char)bufValue[6];
                d.day[1]   = (char)bufValue[7];
                pValue = d;
                break;

            default:
                pValue  = bufValue;
        }
    }

    static void toNative(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        for (int i=0; i<pTemplate.length; i++)
        {
            pTemplate[i].toNative();
        }
    }

    static void toNativeGetSize(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        for (int i=0; i<pTemplate.length; i++)
        {
            pTemplate[i].toNativeGetSize();
        }
    }

    static void toNativeGetValue(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        for (int i=0; i<pTemplate.length; i++)
        {
            pTemplate[i].toNativeGetValue();
        }
    }

    static boolean allKnownSizes(CK_ATTRIBUTE[] pTemplate)
    {
        for (int i=0; i<pTemplate.length; i++)
        {
            if (!pTemplate[i].knownSize()) return false;
        }
        return true;
    }

    static void fromNative(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception
    {
        for (int i=0; i<pTemplate.length; i++)
        {
            pTemplate[i].fromNative();
        }
    }

}
