/*
 * Copyright (c) 2017 Rumen Nikiforov <unafraid89@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.github.unafraid.telegrambot.handlers.inline;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author UnAfraid
 */
public class InlineMenuBuilder
{
	final InlineContext context;
	String name;
	InlineMenu parentMenu;
	final List<InlineButton> buttons = new ArrayList<>();
	
	public InlineMenuBuilder(InlineContext context)
	{
		this(context, null);
	}
	
	public InlineMenuBuilder(InlineContext context, InlineMenu parentMenu)
	{
		this.context = context;
		this.parentMenu = parentMenu;
	}
	
	public InlineMenuBuilder parentMenu(InlineMenu parentMenu)
	{
		this.parentMenu = parentMenu;
		return this;
	}
	
	public InlineMenuBuilder name(String name)
	{
		this.name = name;
		return this;
	}
	
	public InlineMenuBuilder button(InlineButton button)
	{
		Objects.requireNonNull(button);
		buttons.add(button);
		return this;
	}
	
	public InlineMenu build()
	{
		return new InlineMenu(this);
	}
}