/*
 * Decompiled with CFR 0.152.
 */
package com.github.unafraid.telegrambot.util;

import com.github.unafraid.telegrambot.util.CommonUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapUtil.class);
    private final Map<String, Object> values;

    public MapUtil() {
        this.values = new LinkedHashMap<String, Object>();
    }

    public MapUtil(Map<String, Object> map) {
        this.values = map;
    }

    public final Map<String, Object> getInternalMap() {
        return this.values;
    }

    public void merge(MapUtil newSet) {
        Map<String, Object> newMap = newSet.getInternalMap();
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
    }

    public MapUtil put(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
        return this;
    }

    public boolean getBoolean(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Boolean value required, but not specified");
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + val);
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + val);
        }
    }

    public byte getByte(String name, byte defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + val);
        }
    }

    public byte getByte(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Byte value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + val);
        }
    }

    public short getShort(String name, short defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + val);
        }
    }

    public short getShort(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Short value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + val);
        }
    }

    public int getInt(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public int getInteger(String name, int defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public int[] getIntArray(String name, String delimiter) {
        Object val = this.values.get(name);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return new int[]{((Number)val).intValue()};
        }
        int c = 0;
        String[] vals = ((String)val).split(delimiter);
        int[] result = new int[vals.length];
        for (String v : vals) {
            try {
                result[c++] = Integer.parseInt(v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Integer value required, but found: " + val);
            }
        }
        return result;
    }

    public float[] getFloatArray(String name, String delimiter) {
        Object val = this.values.get(name);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return new float[]{((Number)val).floatValue()};
        }
        int c = 0;
        String[] vals = ((String)val).split(delimiter);
        float[] result = new float[vals.length];
        for (String v : vals) {
            try {
                result[c++] = Float.parseFloat(v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Float value required, but found: " + val);
            }
        }
        return result;
    }

    public long getLong(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public long getLong(String name, int defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public float getFloat(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return Float.parseFloat((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public float getFloat(String name, float defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return Float.parseFloat((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public double getDouble(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public double getDouble(String name, float defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public String getString(String name) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("String '" + name + "' value required, but not specified");
        }
        return String.valueOf(val);
    }

    public String getString(String name, String defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        return String.valueOf(val);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) {
        Object val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but not specified");
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but found: " + val);
        }
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass, T defaultValue) {
        Object val = this.values.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + "required, but found: " + val);
        }
    }

    public final <A> A getObject(String name, Class<A> type) {
        Object obj = this.values.get(name);
        if (obj == null || !type.isAssignableFrom(obj.getClass())) {
            return null;
        }
        return (A)obj;
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(clazz);
        Object obj = this.values.get(key);
        if (!(obj instanceof List)) {
            return null;
        }
        List originalList = (List)obj;
        if (!originalList.isEmpty()) {
            if (!originalList.stream().allMatch(clazz::isInstance)) {
                if (clazz.getSuperclass() == Enum.class) {
                    throw new IllegalAccessError("Please use getEnumList if you want to get list of Enums!");
                }
                List<T> convertedList = this.convertList(originalList, clazz);
                if (convertedList == null) {
                    LOGGER.warn("getList(\"{}\", {}) requested with wrong generic type: {}!", new Object[]{key, clazz.getSimpleName(), obj.getClass().getGenericInterfaces()[0], new ClassNotFoundException()});
                    return null;
                }
                this.values.put(key, convertedList);
                return convertedList;
            }
        }
        return (List)obj;
    }

    public <T> List<T> getList(String key, Class<T> clazz, List<T> defaultValue) {
        List<T> list = this.getList(key, clazz);
        return list == null ? defaultValue : list;
    }

    public <T> Set<T> getSet(String key, Class<T> clazz) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(clazz);
        Object obj = this.values.get(key);
        if (obj == null || !(obj instanceof Set)) {
            return null;
        }
        Set originalSet = (Set)obj;
        if (!originalSet.isEmpty()) {
            if (!originalSet.stream().allMatch(clazz::isInstance)) {
                if (clazz.getSuperclass() == Enum.class) {
                    throw new IllegalAccessError("Please use getEnumSet if you want to get set of Enums!");
                }
                Set<T> convertedSet = this.convertSet(originalSet, clazz);
                if (convertedSet == null) {
                    LOGGER.warn("getSet(\"{}\", {}) requested with wrong generic type: {}!", new Object[]{key, clazz.getSimpleName(), obj.getClass().getGenericInterfaces()[0], new ClassNotFoundException()});
                    return null;
                }
                this.values.put(key, convertedSet);
                return convertedSet;
            }
        }
        return (Set)obj;
    }

    public <T> Set<T> getSet(String key, Class<T> clazz, Set<T> defaultValue) {
        Set<T> set = this.getSet(key, clazz);
        return set == null ? defaultValue : set;
    }

    public <T extends Enum<T>> List<T> getEnumList(String key, Class<T> clazz) {
        Object obj = this.values.get(key);
        if (!(obj instanceof List)) {
            return null;
        }
        List originalList = (List)obj;
        if (!originalList.isEmpty() && obj.getClass().getGenericInterfaces()[0] != clazz && originalList.stream().allMatch(name -> CommonUtil.isEnum(name.toString(), clazz))) {
            List convertedList = originalList.stream().map(Object::toString).map(name -> Enum.valueOf(clazz, name)).map(clazz::cast).collect(Collectors.toList());
            this.values.put(key, convertedList);
            return convertedList;
        }
        return (List)obj;
    }

    public <T extends Enum<T>> Set<T> getEnumSet(String key, Class<T> clazz) {
        Object obj = this.values.get(key);
        if (!(obj instanceof List)) {
            return null;
        }
        Set originalSet = (Set)obj;
        if (!originalSet.isEmpty() && obj.getClass().getGenericInterfaces()[0] != clazz && originalSet.stream().allMatch(name -> CommonUtil.isEnum(name.toString(), clazz))) {
            Set convertedSet = originalSet.stream().map(Object::toString).map(name -> Enum.valueOf(clazz, name)).map(clazz::cast).collect(Collectors.toSet());
            this.values.put(key, convertedSet);
            return convertedSet;
        }
        return (Set)obj;
    }

    private <T> List<T> convertList(List<Object> originalList, Class<T> clazz) {
        if (clazz == Integer.class) {
            if (originalList.stream().map(Object::toString).allMatch(CommonUtil::isInteger)) {
                return originalList.stream().map(Object::toString).map(Integer::valueOf).map(clazz::cast).collect(Collectors.toList());
            }
        } else if (clazz == Float.class) {
            if (originalList.stream().map(Object::toString).allMatch(CommonUtil::isFloat)) {
                return originalList.stream().map(Object::toString).map(Float::valueOf).map(clazz::cast).collect(Collectors.toList());
            }
        } else if (clazz == Double.class && originalList.stream().map(Object::toString).allMatch(CommonUtil::isDouble)) {
            return originalList.stream().map(Object::toString).map(Double::valueOf).map(clazz::cast).collect(Collectors.toList());
        }
        return null;
    }

    private <T> Set<T> convertSet(Set<Object> originalSet, Class<T> clazz) {
        if (clazz == Integer.class) {
            if (originalSet.stream().map(Object::toString).allMatch(CommonUtil::isInteger)) {
                return originalSet.stream().map(Object::toString).map(Integer::valueOf).map(clazz::cast).collect(Collectors.toSet());
            }
        } else if (clazz == Float.class) {
            if (originalSet.stream().map(Object::toString).allMatch(CommonUtil::isFloat)) {
                return originalSet.stream().map(Object::toString).map(Float::valueOf).map(clazz::cast).collect(Collectors.toSet());
            }
        } else if (clazz == Double.class && originalSet.stream().map(Object::toString).allMatch(CommonUtil::isDouble)) {
            return originalSet.stream().map(Object::toString).map(Double::valueOf).map(clazz::cast).collect(Collectors.toSet());
        }
        return null;
    }

    public <K, V> Map<K, V> getMap(String key, Class<K> keyClass, Class<V> valueClass) {
        Object obj;
        block4: {
            block5: {
                obj = this.values.get(key);
                if (!(obj instanceof Map)) {
                    return null;
                }
                Map originalList = (Map)obj;
                if (originalList.isEmpty()) break block4;
                if (!originalList.keySet().stream().allMatch(keyClass::isInstance)) break block5;
                if (originalList.values().stream().allMatch(valueClass::isInstance)) break block4;
            }
            LOGGER.warn("getMap(\"{}\", {}, {}) requested with wrong generic type: {}!", new Object[]{key, keyClass.getSimpleName(), valueClass.getSimpleName(), obj.getClass().getGenericInterfaces()[0], new ClassNotFoundException()});
        }
        return (Map)obj;
    }

    public <K, V> Map<K, List<V>> getMapOfList(String key, Class<K> keyClass, Class<V> valueClass) {
        Object obj;
        block4: {
            block5: {
                obj = this.values.get(key);
                if (!(obj instanceof Map)) {
                    return null;
                }
                Map originalList = (Map)obj;
                if (originalList.isEmpty()) break block4;
                if (!originalList.keySet().stream().allMatch(keyClass::isInstance)) break block5;
                if (originalList.values().stream().allMatch(List.class::isInstance)) break block4;
            }
            LOGGER.warn("getMap(\"{}\", {}, {}) requested with wrong generic type: {}!", new Object[]{key, keyClass.getSimpleName(), valueClass.getSimpleName(), obj.getClass().getGenericInterfaces()[0], new ClassNotFoundException()});
        }
        return (Map)obj;
    }
}

