/*
 * Decompiled with CFR 0.152.
 */
package com.github.unafraid.telegrambot.util;

public class CommonUtil {
    public static int parseInt(String intValue, int defaultValue) {
        try {
            return Integer.parseInt(intValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isDigit(String text) {
        try {
            Long.parseLong(text);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isInteger(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        try {
            Integer.decode(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        try {
            Float.parseFloat(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDouble(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T extends Enum<T>> boolean isEnum(String name, Class<T> enumType) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        try {
            Enum.valueOf(enumType, name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

