/*
 * Decompiled with CFR 0.152.
 */
package com.github.unafraid.telegrambot.bots;

import com.github.unafraid.telegrambot.bots.DefaultTelegramBot;
import com.github.unafraid.telegrambot.handlers.IAccessLevelValidator;
import com.github.unafraid.telegrambot.handlers.ICallbackQueryHandler;
import com.github.unafraid.telegrambot.handlers.IChannelPostHandler;
import com.github.unafraid.telegrambot.handlers.IChatJoinRequestHandler;
import com.github.unafraid.telegrambot.handlers.IChatMemberHandler;
import com.github.unafraid.telegrambot.handlers.IChosenInlineQueryHandler;
import com.github.unafraid.telegrambot.handlers.ICommandHandler;
import com.github.unafraid.telegrambot.handlers.IDocumentMessageHandler;
import com.github.unafraid.telegrambot.handlers.IEditedChannelPostHandler;
import com.github.unafraid.telegrambot.handlers.IEditedMessageHandler;
import com.github.unafraid.telegrambot.handlers.IHasMyChatMemberHandler;
import com.github.unafraid.telegrambot.handlers.IInlineQueryHandler;
import com.github.unafraid.telegrambot.handlers.IMessageHandler;
import com.github.unafraid.telegrambot.handlers.IPollAnswerHandler;
import com.github.unafraid.telegrambot.handlers.IPollHandler;
import com.github.unafraid.telegrambot.handlers.IPreCheckoutQueryHandler;
import com.github.unafraid.telegrambot.handlers.IShippingQueryHandler;
import com.github.unafraid.telegrambot.handlers.ITelegramHandler;
import com.github.unafraid.telegrambot.handlers.IUnknownUpdateHandler;
import com.github.unafraid.telegrambot.handlers.IUpdateHandler;
import com.github.unafraid.telegrambot.util.BotUtil;
import com.github.unafraid.telegrambot.util.IThrowableFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.objects.CallbackQuery;
import org.telegram.telegrambots.meta.api.objects.ChatJoinRequest;
import org.telegram.telegrambots.meta.api.objects.ChatMemberUpdated;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.api.objects.inlinequery.ChosenInlineQuery;
import org.telegram.telegrambots.meta.api.objects.inlinequery.InlineQuery;
import org.telegram.telegrambots.meta.api.objects.payments.PreCheckoutQuery;
import org.telegram.telegrambots.meta.api.objects.payments.ShippingQuery;
import org.telegram.telegrambots.meta.api.objects.polls.PollAnswer;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

public class AbstractTelegramBot
extends TelegramLongPollingBot {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTelegramBot.class);
    private static final Pattern COMMAND_ARGS_PATTERN = Pattern.compile("\"([^\"]*)\"|([^\\s]+)");
    private final List<ITelegramHandler> handlers = new ArrayList<ITelegramHandler>();
    private volatile IAccessLevelValidator accessLevelValidator = null;
    private final String _token;
    private final String _username;

    public AbstractTelegramBot(String token, String username) {
        this(token, username, new DefaultBotOptions());
    }

    public AbstractTelegramBot(String token, String username, DefaultBotOptions defaultBotOptions) {
        super(defaultBotOptions);
        this._token = token;
        this._username = username;
    }

    public void onUpdateReceived(Update update) {
        try {
            List<IUpdateHandler> updateHandlers = this.getAvailableHandlers(IUpdateHandler.class);
            for (IUpdateHandler updateHandler : updateHandlers) {
                try {
                    if (!updateHandler.onUpdate(this, update)) continue;
                    return;
                }
                catch (Exception ex) {
                    LOGGER.error("Uncaught exception in onUpdate: {}", (Object)update, (Object)ex);
                }
            }
            if (update.hasChosenInlineQuery()) {
                this.handleUpdate(IChosenInlineQueryHandler.class, update, Update::getChosenInlineQuery, ChosenInlineQuery::getFrom, handler -> handler.onChosenInlineQuery(this, update, update.getChosenInlineQuery()));
                return;
            }
            if (update.hasInlineQuery()) {
                this.handleUpdate(IInlineQueryHandler.class, update, Update::getInlineQuery, InlineQuery::getFrom, handler -> handler.onInlineQuery(this, update, update.getInlineQuery()));
                return;
            }
            if (update.hasCallbackQuery()) {
                this.handleUpdate(ICallbackQueryHandler.class, update, Update::getCallbackQuery, CallbackQuery::getFrom, handler -> handler.onCallbackQuery(this, update, update.getCallbackQuery()));
                return;
            }
            if (update.hasEditedMessage()) {
                this.handleUpdate(IEditedMessageHandler.class, update, Update::getEditedMessage, Message::getFrom, handler -> handler.onEditMessage(this, update, update.getEditedMessage()));
                return;
            }
            if (update.hasChannelPost()) {
                this.handleUpdate(IChannelPostHandler.class, update, Update::getChannelPost, Message::getFrom, handler -> handler.onChannelPost(this, update, update.getChannelPost()));
                return;
            }
            if (update.hasEditedChannelPost()) {
                this.handleUpdate(IEditedChannelPostHandler.class, update, Update::getChannelPost, Message::getFrom, handler -> handler.onEditedChannelPost(this, update, update.getEditedChannelPost()));
                return;
            }
            if (update.hasShippingQuery()) {
                this.handleUpdate(IShippingQueryHandler.class, update, Update::getShippingQuery, ShippingQuery::getFrom, handler -> handler.onShippingQuery(this, update, update.getShippingQuery()));
                return;
            }
            if (update.hasPreCheckoutQuery()) {
                this.handleUpdate(IPreCheckoutQueryHandler.class, update, Update::getPreCheckoutQuery, PreCheckoutQuery::getFrom, handler -> handler.onPreCheckoutQuery(this, update, update.getPreCheckoutQuery()));
                return;
            }
            if (update.hasPoll()) {
                this.handleUpdate(IPollHandler.class, update, u -> u, u -> u.getMessage().getFrom(), handler -> handler.onPoll(this, update, update.getPoll()));
                return;
            }
            if (update.hasPollAnswer()) {
                this.handleUpdate(IPollAnswerHandler.class, update, Update::getPollAnswer, PollAnswer::getUser, handler -> handler.onPollAnswer(this, update, update.getPollAnswer()));
                return;
            }
            if (update.hasMyChatMember()) {
                this.handleUpdate(IHasMyChatMemberHandler.class, update, Update::getMyChatMember, ChatMemberUpdated::getFrom, handler -> handler.onHasMyChatMember(this, update, update.getMyChatMember()));
                return;
            }
            if (update.hasChatMember()) {
                this.handleUpdate(IChatMemberHandler.class, update, Update::getChatMember, ChatMemberUpdated::getFrom, handler -> handler.onChatMember(this, update, update.getChatMember()));
                return;
            }
            if (update.hasChatJoinRequest()) {
                this.handleUpdate(IChatJoinRequestHandler.class, update, Update::getChatJoinRequest, ChatJoinRequest::getUser, handler -> handler.onChatJoinRequest(this, update, update.getChatJoinRequest()));
                return;
            }
            if (update.hasMessage()) {
                if (update.getMessage().hasDocument()) {
                    this.handleUpdate(IDocumentMessageHandler.class, update, Update::getMessage, Message::getFrom, handler -> handler.onDocumentSent(this, update, update.getMessage()));
                    return;
                }
                this.handleIncomingMessage(update);
                return;
            }
            List<IUnknownUpdateHandler> unknownHandlers = this.getAvailableHandlers(IUnknownUpdateHandler.class);
            if (unknownHandlers.isEmpty()) {
                LOGGER.warn("Update doesn't contains neither ChosenInlineQuery/InlineQuery/CallbackQuery/EditedMessage/ChannelPost/EditedChannelPost/Message Update: {}", (Object)update);
                return;
            }
            for (IUnknownUpdateHandler unknownHandler : unknownHandlers) {
                try {
                    if (!unknownHandler.onUnhandledUpdate(this, update)) continue;
                    return;
                }
                catch (Exception ex) {
                    LOGGER.error("Uncaught exception in onUnhandledUpdate: {}", (Object)update, (Object)ex);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle incoming update", (Throwable)e);
        }
    }

    private <T extends ITelegramHandler, R> void handleUpdate(Class<T> clazz, Update update, Function<Update, R> dataMapper, Function<R, User> idMapper, IThrowableFunction<T, Boolean> action) {
        R query = dataMapper.apply(update);
        if (query == null) {
            return;
        }
        User user = idMapper.apply(query);
        List<T> handlers = this.getAvailableHandlersForUser(clazz, user);
        for (ITelegramHandler handler : handlers) {
            try {
                if (!action.apply(handler).booleanValue()) continue;
                break;
            }
            catch (TelegramApiRequestException e) {
                LOGGER.warn("Exception caught on handler: {} error: {}", new Object[]{handler.getClass().getSimpleName(), e.getApiResponse(), e});
            }
            catch (Exception e) {
                LOGGER.warn("Exception caught on handler: {}", (Object)handler.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    protected String processText(String text) {
        if (text == null || ((String)text).isEmpty()) {
            return null;
        }
        if (((String)text).startsWith("@" + this.getBotUsername() + " ")) {
            text = "/" + ((String)text).substring(("@" + this.getBotUsername() + " ").length());
        } else if (((String)text).contains("@" + this.getBotUsername()) && ((String)(text = ((String)text).replaceAll("@" + this.getBotUsername(), ""))).charAt(0) != '/') {
            text = "/" + (String)text;
        }
        return text;
    }

    private void handleIncomingMessage(Update update) {
        Message message = update.getMessage();
        if (message == null) {
            return;
        }
        String text = this.processText(message.getText());
        if (text == null || text.isEmpty()) {
            return;
        }
        Matcher matcher = COMMAND_ARGS_PATTERN.matcher(text);
        if (matcher.find()) {
            String command = matcher.group();
            ArrayList<String> args = new ArrayList<String>();
            while (matcher.find()) {
                String arg = matcher.group(1);
                if (arg == null) {
                    arg = matcher.group(0);
                }
                args.add(arg);
            }
            ICommandHandler handler = this.getHandler(command);
            if (handler != null) {
                try {
                    if (!this.validateAccessLevel(handler, message.getFrom())) {
                        BotUtil.sendMessage(this, message, message.getFrom().getUserName() + ": You are not authorized to use this function!", true, false, null);
                        return;
                    }
                    handler.onCommandMessage(this, update, message, args);
                }
                catch (TelegramApiRequestException e) {
                    LOGGER.warn("API Exception caught on handler: {}, response: {} message: {}", new Object[]{handler.getClass().getSimpleName(), e.getApiResponse(), message, e});
                }
                catch (Exception e) {
                    LOGGER.warn("Exception caught on handler: {}, message: {}", new Object[]{handler.getClass().getSimpleName(), message, e});
                }
            } else {
                for (IMessageHandler messageHandler : this.getAvailableHandlersForUser(IMessageHandler.class, message.getFrom())) {
                    try {
                        if (!messageHandler.onMessage(this, update, message)) continue;
                        break;
                    }
                    catch (TelegramApiRequestException e) {
                        LOGGER.warn("API Exception caught on handler: {}, response: {} message: {}", new Object[]{messageHandler.getClass().getSimpleName(), e.getApiResponse(), message, e});
                    }
                    catch (Exception e) {
                        LOGGER.warn("Exception caught on handler: {}, message: {}", new Object[]{messageHandler.getClass().getSimpleName(), message, e});
                    }
                }
            }
        }
    }

    public String getBotUsername() {
        return this._username;
    }

    public String getBotToken() {
        return this._token;
    }

    public void setAccessLevelValidator(IAccessLevelValidator accessLevelValidator) {
        this.accessLevelValidator = accessLevelValidator;
    }

    public IAccessLevelValidator getAccessLevelValidator() {
        return this.accessLevelValidator;
    }

    public void addHandler(ITelegramHandler handler) {
        this.handlers.add(handler);
    }

    public boolean removeHandler(ITelegramHandler handler) {
        return this.handlers.remove(handler);
    }

    public ICommandHandler getHandler(String command) {
        return this.handlers.stream().filter(handler -> handler instanceof ICommandHandler).map(handler -> (ICommandHandler)handler).filter(handler -> handler.getCommand().equalsIgnoreCase(command)).findFirst().orElse(null);
    }

    public Collection<ITelegramHandler> getHandlers() {
        return Collections.unmodifiableCollection(this.handlers);
    }

    public <T extends ITelegramHandler> List<T> getAvailableHandlers(Class<T> clazz) {
        return this.handlers.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public <T extends ITelegramHandler> List<T> getAvailableHandlersForUser(Class<T> clazz, User user) {
        return this.handlers.stream().filter(clazz::isInstance).map(clazz::cast).filter(messageHandler -> this.validateAccessLevel(messageHandler, user)).collect(Collectors.toList());
    }

    public <T extends ITelegramHandler> boolean validateAccessLevel(T handler, User user) {
        IAccessLevelValidator accessLevelValidator = this.accessLevelValidator;
        if (accessLevelValidator == null) {
            if (handler.getRequiredAccessLevel() > 0) {
                throw new IllegalStateException("Discovered handler with required access level > 0 but there's no access level validator implemented, please use DefaultTelegramBot#setAccessLevelValidator");
            }
            return true;
        }
        return accessLevelValidator.validate(handler, user);
    }
}

