/*
 * Decompiled with CFR 0.152.
 */
package com.github.tsouza.promises.internal;

import com.github.tsouza.promises.Promise;
import com.github.tsouza.promises.PromiseOrValue;
import com.github.tsouza.promises.Value;
import com.github.tsouza.promises.functions.Callable;
import com.github.tsouza.promises.functions.Mapper;
import com.github.tsouza.promises.functions.Receiver;
import com.github.tsouza.promises.functions.Spread;
import com.github.tsouza.promises.internal.RxObserverAdapter;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RxPromiseAdapter<R>
implements Promise<R> {
    private final RxObserverAdapter<R> rxPromise;

    public RxPromiseAdapter(R value) {
        this.rxPromise = new RxObserverAdapter();
        this.rxPromise.fulfill(value);
    }

    public RxPromiseAdapter(Throwable exception) {
        this.rxPromise = new RxObserverAdapter();
        this.rxPromise.reject(exception);
    }

    public RxPromiseAdapter(RxObserverAdapter<R> rxPromise) {
        this.rxPromise = rxPromise;
    }

    @Override
    public <NR> Promise<NR> then(Mapper<R, PromiseOrValue<NR>> mapper) {
        return new RxPromiseAdapter(this.rxPromise.then(r -> this.chain(r, mapper)));
    }

    @Override
    public <NR> Promise<NR> then(Mapper<R, PromiseOrValue<NR>> success, Mapper<Throwable, PromiseOrValue<R>> failure) {
        return new RxPromiseAdapter(this.rxPromise.then(r -> this.chain(r, success), e -> this.chain(e, failure)));
    }

    @Override
    public <T extends Throwable> Promise<R> fail(Class<T> exceptionType, Mapper<T, PromiseOrValue<R>> mapper) {
        return new RxPromiseAdapter(this.rxPromise.fail(exception -> {
            if (!exceptionType.isAssignableFrom(exception.getClass())) {
                return this.rxPromise;
            }
            return this.chain(exception, mapper);
        }));
    }

    @Override
    public Promise<R> tap(Mapper<R, Promise<?>> mapper) {
        return new RxPromiseAdapter(this.rxPromise.then(r -> {
            Promise tapPromise = null;
            try {
                tapPromise = (Promise)mapper.map(r);
            }
            catch (Throwable e) {
                this.rxPromise.reject(e);
                return this.rxPromise;
            }
            if (tapPromise == null) {
                return this.rxPromise;
            }
            RxObserverAdapter newPromise = new RxObserverAdapter();
            tapPromise.done(newPromise::fulfill, newPromise::reject);
            return newPromise;
        }));
    }

    @Override
    public Promise<R> always(Callable<Promise<R>> callable) {
        return new RxPromiseAdapter(this.rxPromise.always(() -> {
            Promise finallyPromise = null;
            try {
                finallyPromise = (Promise)callable.call();
            }
            catch (Throwable e) {
                this.rxPromise.reject(e);
            }
            if (finallyPromise == null) {
                return this.rxPromise;
            }
            RxObserverAdapter newPromise = new RxObserverAdapter();
            finallyPromise.done(success -> {
                if (this.rxPromise.isFulfilled()) {
                    newPromise.fulfill(this.rxPromise.getResult());
                } else {
                    newPromise.reject(this.rxPromise.getReason());
                }
            }, newPromise::reject);
            return newPromise;
        }));
    }

    @Override
    public <T1, T2, NR> Promise<NR> spread(Spread.Args2<T1, T2, PromiseOrValue<NR>> spread) {
        return new RxPromiseAdapter(this.rxPromise.then(r -> this.chain(this.coerceToArray(r), input -> (PromiseOrValue)spread.call(this.safeGet(0, (Object[])input), this.safeGet(1, (Object[])input)))));
    }

    @Override
    public <T1, T2, T3, NR> Promise<NR> spread(Spread.Args3<T1, T2, T3, PromiseOrValue<NR>> spread) {
        return new RxPromiseAdapter(this.rxPromise.then(r -> this.chain(this.coerceToArray(r), input -> (PromiseOrValue)spread.call(this.safeGet(0, (Object[])input), this.safeGet(1, (Object[])input), this.safeGet(2, (Object[])input)))));
    }

    @Override
    public <T1, T2, T3, T4, NR> Promise<NR> spread(Spread.Args4<T1, T2, T3, T4, PromiseOrValue<NR>> spread) {
        return new RxPromiseAdapter(this.rxPromise.then(r -> this.chain(this.coerceToArray(r), input -> (PromiseOrValue)spread.call(this.safeGet(0, (Object[])input), this.safeGet(1, (Object[])input), this.safeGet(2, (Object[])input), this.safeGet(3, (Object[])input)))));
    }

    @Override
    public <T1, T2, T3, T4, T5, NR> Promise<NR> spread(Spread.Args5<T1, T2, T3, T4, T5, PromiseOrValue<NR>> spread) {
        return new RxPromiseAdapter(this.rxPromise.then(r -> this.chain(this.coerceToArray(r), input -> (PromiseOrValue)spread.call(this.safeGet(0, (Object[])input), this.safeGet(1, (Object[])input), this.safeGet(2, (Object[])input), this.safeGet(3, (Object[])input), this.safeGet(4, (Object[])input)))));
    }

    @Override
    public void done(Receiver<R> success, Receiver<Throwable> failure) {
        this.rxPromise.done(() -> {
            try {
                if (this.rxPromise.isFulfilled()) {
                    try {
                        success.receive(this.rxPromise.getResult());
                    }
                    catch (Throwable e) {
                        if (failure != null) {
                            failure.receive(e);
                        }
                    }
                } else if (failure != null) {
                    failure.receive(this.rxPromise.getReason());
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void done(Receiver<R> success) {
        this.done(success, null);
    }

    @Override
    public Future<R> future() {
        CountDownLatch latch = new CountDownLatch(1);
        this.rxPromise.done(latch::countDown);
        return new FutureAdapter(latch);
    }

    private <I> RxObserverAdapter chain(I input, Mapper<I, ?> mapper) {
        Object promiseOrValue;
        RxObserverAdapter<Object> newPromise = new RxObserverAdapter<Object>();
        try {
            promiseOrValue = mapper.map(input);
        }
        catch (Throwable e) {
            newPromise.reject(e);
            return newPromise;
        }
        if (promiseOrValue instanceof Promise) {
            ((Promise)promiseOrValue).done(newPromise::fulfill, newPromise::reject);
        } else if (promiseOrValue instanceof Value) {
            newPromise.fulfill(((Value)promiseOrValue).get());
        } else {
            newPromise.fulfill(promiseOrValue);
        }
        return newPromise;
    }

    private Object[] coerceToArray(Object value) {
        if (value == null) {
            return new Object[0];
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        if (value instanceof Collection) {
            return ((Collection)value).toArray();
        }
        return new Object[]{value};
    }

    private Object safeGet(int idx, Object[] array) {
        return array == null || idx > array.length ? null : array[idx];
    }

    class FutureAdapter
    implements Future<R> {
        private final CountDownLatch latch;

        public FutureAdapter(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public boolean isDone() {
            return RxPromiseAdapter.this.rxPromise.isDone();
        }

        @Override
        public synchronized R get() throws InterruptedException, ExecutionException {
            if (this.isDone()) {
                return this.getResult();
            }
            this.latch.await();
            return this.getResult();
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.isDone()) {
                return this.getResult();
            }
            this.latch.await(timeout, unit);
            return this.getResult();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("promises are not cancellable");
        }

        private R getResult() throws ExecutionException {
            if (this.isDone()) {
                if (RxPromiseAdapter.this.rxPromise.getReason() != null) {
                    throw new ExecutionException(RxPromiseAdapter.this.rxPromise.getReason());
                }
                return RxPromiseAdapter.this.rxPromise.getResult();
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }
}

