/*
 * Decompiled with CFR 0.152.
 */
package com.github.tsouza.promises.internal;

import com.github.tsouza.promises.internal.functions.OnFinally;
import com.github.tsouza.promises.internal.functions.OnFulfilled;
import com.github.tsouza.promises.internal.functions.OnRejected;
import java.util.concurrent.Future;
import rx.Observable;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Function;
import rx.subjects.ReplaySubject;

public class RxObserverAdapter<R>
implements Observer<R> {
    private final ReplaySubject<R> subject;
    private final Observable<R> observable;
    private State state = State.PENDING;
    private R result = null;
    private Throwable reason;

    public RxObserverAdapter() {
        this(null);
    }

    private RxObserverAdapter(Observable<R> source) {
        this.subject = ReplaySubject.create();
        this.observable = this.subject.last();
        if (source != null) {
            source.subscribe(this.subject);
        }
        this.observable.subscribe((Observer)new StateObserver());
    }

    public boolean isFulfilled() {
        return this.state == State.FULFILLED;
    }

    public boolean isDone() {
        return this.state != State.PENDING;
    }

    public State getState() {
        return this.state;
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getReason() {
        return this.reason;
    }

    public Future<R> toFuture() {
        return this.subject.toBlocking().toFuture();
    }

    public void fulfill(R result) {
        this.subject.onNext(result);
        this.subject.onCompleted();
    }

    public void reject(Throwable reason) {
        this.subject.onError(reason);
    }

    public void become(RxObserverAdapter<R> other) {
        other.subject.subscribe((Observer)this);
    }

    public <NR> RxObserverAdapter<NR> then(OnFulfilled<R, NR> onFulfilled) {
        return this.then((Function)onFulfilled, null, null);
    }

    public <NR> RxObserverAdapter<NR> then(OnFulfilled<R, NR> onFulfilled, OnRejected<NR> onRejected) {
        return this.then((Function)onFulfilled, (Function)onRejected, null);
    }

    public <NR> RxObserverAdapter<NR> fail(OnRejected<NR> onRejected) {
        return this.then(null, (Function)onRejected, null);
    }

    public <NR> RxObserverAdapter<NR> always(OnFinally<NR> onFinally) {
        return this.then(null, null, (Function)onFinally);
    }

    public void done(Action0 onDone) {
        this.then(null, null, (Function)onDone);
    }

    public <NR> RxObserverAdapter<NR> then(Function onFulfilled, Function onRejected, Function onFinally) {
        ChainedObserver chain = new ChainedObserver(onFulfilled, onRejected, onFinally);
        this.observable.subscribe(chain);
        return chain.next;
    }

    public void onCompleted() {
        this.fulfill(this.result);
    }

    public void onError(Throwable e) {
        this.reject(e);
    }

    public void onNext(R r) {
        this.result = r;
    }

    public static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }

    class ChainedObserver<NR>
    implements Observer<R> {
        private final Function onFulfilled;
        private final Function onRejected;
        private final Function onFinally;
        private final RxObserverAdapter<NR> next = new RxObserverAdapter();

        ChainedObserver(Function onFulfilled, Function onRejected, Function onFinally) {
            this.onFulfilled = onFulfilled;
            this.onRejected = onRejected;
            this.onFinally = onFinally;
        }

        public void onCompleted() {
            this.evaluate();
        }

        public void onError(Throwable e) {
            this.evaluate();
        }

        public void onNext(R r) {
        }

        private void evaluate() {
            try {
                if (this.onFinally != null) {
                    this.evaluateFinally();
                } else if (State.FULFILLED == RxObserverAdapter.this.state) {
                    this.evaluateFulfilled();
                } else if (State.REJECTED == RxObserverAdapter.this.state) {
                    this.evaluateRejected();
                }
            }
            catch (Throwable e) {
                this.next.reject(e);
            }
        }

        private void evaluateFinally() {
            RxObserverAdapter<?> result = this.callFinally();
            if (result != null) {
                result.then((Function)((Action1)this.next::fulfill), (Function)((Action1)this.next::reject), null);
            } else if (State.FULFILLED == RxObserverAdapter.this.state) {
                this.next.fulfill(result);
            } else {
                this.next.reject(RxObserverAdapter.this.reason);
            }
        }

        private void evaluateFulfilled() {
            if (this.onFulfilled != null) {
                this.evalResult(this.callFunction(this.onFulfilled, RxObserverAdapter.this.result));
            } else {
                this.next.fulfill(RxObserverAdapter.this.result);
            }
        }

        private void evaluateRejected() {
            if (this.onRejected != null) {
                this.evalResult(this.callFunction(this.onRejected, RxObserverAdapter.this.reason));
            } else {
                this.next.reject(RxObserverAdapter.this.reason);
            }
        }

        private RxObserverAdapter<?> callFinally() {
            if (this.onFinally instanceof Func0) {
                return (RxObserverAdapter)((Func0)this.onFinally).call();
            }
            ((Action0)this.onFinally).call();
            return null;
        }

        private <O> Object callFunction(Function function, O value) {
            if (function instanceof Action0) {
                ((Action0)function).call();
                return null;
            }
            if (function instanceof Action1) {
                ((Action1)function).call(value);
                return null;
            }
            if (function instanceof Func0) {
                return ((Func0)function).call();
            }
            if (function instanceof Func1) {
                return ((Func1)function).call(value);
            }
            throw new IllegalArgumentException("Unknown type of function " + function.getClass().getName());
        }

        private void evalResult(Object result) {
            if (result instanceof RxObserverAdapter) {
                this.next.become((RxObserverAdapter)result);
            } else {
                this.next.fulfill(result);
            }
        }
    }

    class StateObserver
    implements Observer<R> {
        StateObserver() {
        }

        public void onCompleted() {
            RxObserverAdapter.this.state = State.FULFILLED;
        }

        public void onError(Throwable e) {
            RxObserverAdapter.this.state = State.REJECTED;
            RxObserverAdapter.this.reason = e;
        }

        public void onNext(R r) {
            RxObserverAdapter.this.result = r;
        }
    }
}

