/*
 * Decompiled with CFR 0.152.
 */
package com.github.tsouza.promises;

import com.github.tsouza.promises.Deferred;
import com.github.tsouza.promises.Promise;
import com.github.tsouza.promises.PromiseOrValue;
import com.github.tsouza.promises.Resolver;
import com.github.tsouza.promises.ThreadProfile;
import com.github.tsouza.promises.Value;
import com.github.tsouza.promises.functions.Callable;
import com.github.tsouza.promises.functions.Mapper;
import com.github.tsouza.promises.functions.Receiver;
import com.github.tsouza.promises.functions.Reducer;
import com.github.tsouza.promises.spi.DeferredManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Promises {
    private static DeferredManager MANAGER;

    public static <R> Promise<R> resolve(Object promiseOrValue) {
        if (promiseOrValue instanceof PromiseOrValue) {
            return Promises.resolve((PromiseOrValue)promiseOrValue);
        }
        return Promises.manager().resolved(promiseOrValue);
    }

    public static <R> Promise<R> resolve(PromiseOrValue<R> promiseOrValue) {
        if (promiseOrValue instanceof Promise) {
            return (Promise)promiseOrValue;
        }
        if (promiseOrValue instanceof Value) {
            return Promises.resolve(((Value)promiseOrValue).get());
        }
        throw new InternalError();
    }

    public static <R> Promise<R> resolve(Future<R> future) {
        return Promises.resolve(future, ThreadProfile.IO);
    }

    public static <R> Promise<R> resolve(Future<R> future, ThreadProfile profile) {
        return Promises.defer(resolver -> {
            try {
                resolver.resolve(future.get());
            }
            catch (ExecutionException e) {
                resolver.reject(e.getCause());
            }
        }, profile);
    }

    public static <R> Promise<R> resolve(Future<R> future, ThreadProfile profile, long timeout, TimeUnit unit) {
        return Promises.defer(resolver -> {
            try {
                resolver.resolve(future.get(timeout, unit));
            }
            catch (ExecutionException e) {
                resolver.reject(e.getCause());
            }
        }, profile);
    }

    public static <R> Promise<R> resolve(Future<R> future, long timeout, TimeUnit unit) {
        return Promises.resolve(future, ThreadProfile.IO, timeout, unit);
    }

    public static <R> Value<R> value(R value) {
        return () -> value;
    }

    public static <R> Promise<R> reject(Throwable exception) {
        return Promises.manager().rejected(exception);
    }

    public static <R> Promise<R> defer(Receiver<Resolver<R>> receiver) {
        return Promises.defer(receiver, ThreadProfile.CPU);
    }

    public static <R> Promise<R> defer(Receiver<Resolver<R>> receiver, ThreadProfile profile) {
        Deferred<R> deferred = Promises.deferred();
        Promises.manager().schedule(profile, receiver, deferred.resolver());
        return deferred.promise();
    }

    public static <R> Deferred<R> deferred() {
        return Promises.manager().deferred();
    }

    public static <R> Promise<R> resolve(Callable<PromiseOrValue<R>> callback) {
        try {
            return Promises.resolve(callback.call());
        }
        catch (Throwable e) {
            return Promises.reject(e);
        }
    }

    public static <I, O> Promise<List<O>> map(Object[] promisesOrValues, Mapper<I, PromiseOrValue<O>> mapper) {
        return Promises.map(Arrays.asList(promisesOrValues), mapper);
    }

    public static <I, O> Promise<List<O>> map(Collection<Object> promisesOrValues, Mapper<I, PromiseOrValue<O>> mapper) {
        if (promisesOrValues == null || promisesOrValues.size() == 0) {
            return Promises.resolve(Collections.emptyList());
        }
        return Promises.defer(resolver -> {
            Object[] result = new Object[promisesOrValues.size()];
            AtomicInteger replyCount = new AtomicInteger(promisesOrValues.size());
            int i = 0;
            for (Object promiseOrValue : promisesOrValues) {
                int idx = i++;
                Promises.resolve(promiseOrValue).then(mapper::map).done(success -> {
                    objectArray[n] = success;
                    if (replyCount.decrementAndGet() == 0) {
                        resolver.resolve(Arrays.asList(result));
                    }
                }, resolver::reject);
            }
        });
    }

    public static <R> Promise<R> reduce(Object[] promisesOrValues, Reducer<R, PromiseOrValue<R>> reducer, R initialValue) {
        return Promises.reduce(Arrays.asList(promisesOrValues), reducer, initialValue);
    }

    public static <R> Promise<R> reduce(Iterable<Object> promisesOrValues, Reducer<R, PromiseOrValue<R>> reducer, R initialValue) {
        if (promisesOrValues == null) {
            return Promises.resolve(initialValue);
        }
        return Promises.reduceNext(promisesOrValues.iterator(), reducer, initialValue);
    }

    private static <R> Promise<R> reduceNext(Iterator<R> promisesOrValues, Reducer<R, PromiseOrValue<R>> reducer, R previousValue) {
        if (!promisesOrValues.hasNext()) {
            return Promises.resolve(previousValue);
        }
        return Promises.resolve(promisesOrValues.next()).then(currentValue -> (PromiseOrValue)reducer.reduce(previousValue, currentValue)).then(nextValue -> Promises.reduceNext(promisesOrValues, reducer, nextValue));
    }

    public static <R> Promise<List<R>> join(Object ... promisesOrValues) {
        return Promises.all(promisesOrValues);
    }

    public static <R> Promise<List<R>> all(Object[] promisesOrValues) {
        return Promises.all(Arrays.asList(promisesOrValues));
    }

    public static <R> Promise<List<R>> all(Collection<Object> promisesOrValues) {
        return Promises.map(promisesOrValues, Mapper.noop());
    }

    private static DeferredManager manager() {
        if (MANAGER == null) {
            MANAGER = ServiceLoader.load(DeferredManager.class, DeferredManager.class.getClassLoader()).iterator().next();
        }
        return MANAGER;
    }
}

