/*
 * Decompiled with CFR 0.152.
 */
package com.github.tsouza.promises;

import com.github.tsouza.promises.PromiseOrValue;
import com.github.tsouza.promises.Promises;
import com.github.tsouza.promises.functions.Callable;
import com.github.tsouza.promises.functions.Mapper;
import com.github.tsouza.promises.functions.Receiver;
import com.github.tsouza.promises.functions.Reducer;
import com.github.tsouza.promises.functions.Spread;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;

public interface Promise<R>
extends PromiseOrValue<R> {
    public <NR> Promise<NR> then(Mapper<R, PromiseOrValue<NR>> var1);

    public <NR> Promise<NR> then(Mapper<R, PromiseOrValue<NR>> var1, Mapper<Throwable, PromiseOrValue<R>> var2);

    public <T extends Throwable> Promise<R> fail(Class<T> var1, Mapper<T, PromiseOrValue<R>> var2);

    default public Promise<R> fail(Mapper<Throwable, PromiseOrValue<R>> mapper) {
        return this.fail(Throwable.class, mapper);
    }

    public Promise<R> tap(Mapper<R, Promise<?>> var1);

    default public <I, O> Promise<List<O>> map(Mapper<I, PromiseOrValue<O>> mapper) {
        return this.then(success -> {
            if (success == null) {
                return null;
            }
            if (success instanceof Collection) {
                return Promises.map((Collection)success, mapper);
            }
            if (success instanceof Object[]) {
                return Promises.map((Object[])success, mapper);
            }
            throw new IllegalStateException(success.getClass() + " is not a collection (can not map it)");
        });
    }

    default public Promise<R> reduce(Reducer<R, PromiseOrValue<R>> reducer, R initialValue) {
        return this.then(success -> {
            if (success == null) {
                return null;
            }
            if (success instanceof Collection) {
                return Promises.reduce((Collection)success, reducer, initialValue);
            }
            if (success instanceof Object[]) {
                return Promises.reduce((Object[])success, reducer, initialValue);
            }
            throw new IllegalStateException(success.getClass() + " is not a collection (can not reduce it)");
        });
    }

    default public Promise<R> reduce(Reducer<R, PromiseOrValue<R>> reducer) {
        return this.reduce(reducer, null);
    }

    default public <NR> Promise<NR> yield(NR result) {
        return this.then(success -> Promises.resolve(result));
    }

    default public <NR> Promise<NR> yield(PromiseOrValue<NR> result) {
        return this.then(success -> Promises.resolve(result));
    }

    public Promise<R> always(Callable<Promise<R>> var1);

    public <T1, T2, NR> Promise<NR> spread(Spread.Args2<T1, T2, PromiseOrValue<NR>> var1);

    public <T1, T2, T3, NR> Promise<NR> spread(Spread.Args3<T1, T2, T3, PromiseOrValue<NR>> var1);

    public <T1, T2, T3, T4, NR> Promise<NR> spread(Spread.Args4<T1, T2, T3, T4, PromiseOrValue<NR>> var1);

    public <T1, T2, T3, T4, T5, NR> Promise<NR> spread(Spread.Args5<T1, T2, T3, T4, T5, PromiseOrValue<NR>> var1);

    public void done(Receiver<R> var1, Receiver<Throwable> var2);

    public void done(Receiver<R> var1);

    public Future<R> future();
}

