/*
 * Decompiled with CFR 0.152.
 */
package com.trickl.flux.websocket;

import com.trickl.exceptions.StepVerifierException;
import com.trickl.flux.websocket.ClosedWebSocketStepsBuilder;
import com.trickl.flux.websocket.MockWebServerListener;
import com.trickl.flux.websocket.MockWebSocketListener;
import com.trickl.flux.websocket.WebSocketStepType;
import java.time.Duration;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import okhttp3.WebSocket;
import okhttp3.mockwebserver.MockWebServer;
import org.springframework.web.reactive.socket.CloseStatus;
import reactor.core.scheduler.Scheduler;

public final class OpenWebSocketStepsBuilder {
    private static final Logger log = Logger.getLogger(OpenWebSocketStepsBuilder.class.getName());
    private final Supplier<MockWebServer> serverSupplier;
    private final MockWebServerListener mockWebServerListener;
    private final MockWebSocketListener mockWebSocketListener;
    private final Scheduler scheduler;
    private final Queue<Runnable> steps;
    private static final String WAIT_INTERRUPTED_MESSAGE = "Wait Interrupted";

    public OpenWebSocketStepsBuilder thenSend(String payload) {
        this.steps.add(() -> {
            WebSocket ws = this.mockWebSocketListener.getWebSocket();
            if (ws != null) {
                ws.send(payload);
            }
        });
        return this;
    }

    public OpenWebSocketStepsBuilder thenExpectMessage(String body) {
        return this.thenExpectMessage(body, Duration.ofSeconds(10L));
    }

    public OpenWebSocketStepsBuilder thenExpectMessage(String body, Duration timeout) {
        return this.thenExpectMessage((String text) -> text.equals(body), timeout);
    }

    public OpenWebSocketStepsBuilder thenExpectMessage(Pattern bodyPattern) {
        return this.thenExpectMessage(bodyPattern, Duration.ofSeconds(10L));
    }

    public OpenWebSocketStepsBuilder thenExpectMessage(Pattern bodyPattern, Duration timeout) {
        return this.thenExpectMessage((String text) -> bodyPattern.matcher((CharSequence)text).matches(), timeout);
    }

    public OpenWebSocketStepsBuilder thenExpectMessage(Predicate<String> bodyMatcher) {
        return this.thenExpectMessage(bodyMatcher, Duration.ofSeconds(10L));
    }

    public OpenWebSocketStepsBuilder thenExpectMessage(Predicate<String> bodyMatcher, Duration timeout) {
        this.steps.add(() -> this.testWasMessage(bodyMatcher, timeout));
        return this;
    }

    protected void testWasMessage(Predicate<String> bodyMatcher, Duration timeout) {
        log.info("Waiting on MESSAGE");
        WebSocketStepType nextStep = this.mockWebSocketListener.nextStep(timeout);
        String nextMessage = Optional.ofNullable(this.mockWebSocketListener.getMessages().poll()).orElse("<null>");
        if (!nextStep.equals((Object)WebSocketStepType.MESSAGE)) {
            throw new StepVerifierException("Expected MESSAGE got - " + (Object)((Object)nextStep));
        }
        if (!bodyMatcher.test(nextMessage)) {
            throw new StepVerifierException("Unexpected message - " + nextMessage);
        }
    }

    public OpenWebSocketStepsBuilder thenWait(Duration period) {
        this.steps.add(() -> {
            try {
                log.info("Waiting for " + period);
                TimeUnit.MILLISECONDS.sleep(period.toMillis());
            }
            catch (InterruptedException ex) {
                log.info(WAIT_INTERRUPTED_MESSAGE);
                Thread.currentThread().interrupt();
            }
        });
        return this;
    }

    public ClosedWebSocketStepsBuilder thenExpectClose() {
        return this.thenExpectClose(Duration.ofSeconds(10L));
    }

    public ClosedWebSocketStepsBuilder thenExpectClose(Duration timeout) {
        this.steps.add(() -> {
            log.info("Waiting on CLOSING");
            WebSocketStepType nextStep = this.mockWebSocketListener.nextStep(timeout);
            if (!nextStep.equals((Object)WebSocketStepType.CLOSING)) {
                throw new StepVerifierException("Expected CLOSING got - " + (Object)((Object)nextStep));
            }
        });
        this.thenClose();
        this.steps.add(() -> {
            log.info("Waiting on CLOSE");
            WebSocketStepType nextStep = this.mockWebSocketListener.nextStep(timeout);
            if (!nextStep.equals((Object)WebSocketStepType.CLOSE)) {
                throw new StepVerifierException("Expected CLOSE got - " + (Object)((Object)nextStep));
            }
        });
        return new ClosedWebSocketStepsBuilder(this.serverSupplier, this.mockWebServerListener, this.mockWebSocketListener, this.scheduler, this.steps);
    }

    public ClosedWebSocketStepsBuilder thenClose() {
        this.steps.add(() -> {
            WebSocket ws = this.mockWebSocketListener.getWebSocket();
            if (ws != null) {
                log.info("Terminating connection.");
                ws.close(CloseStatus.NORMAL.getCode(), "Normal termination.");
            }
        });
        return new ClosedWebSocketStepsBuilder(this.serverSupplier, this.mockWebServerListener, this.mockWebSocketListener, this.scheduler, this.steps);
    }

    public OpenWebSocketStepsBuilder then(Runnable step) {
        this.steps.add(step);
        return this;
    }

    public OpenWebSocketStepsBuilder(Supplier<MockWebServer> serverSupplier, MockWebServerListener mockWebServerListener, MockWebSocketListener mockWebSocketListener, Scheduler scheduler, Queue<Runnable> steps) {
        this.serverSupplier = serverSupplier;
        this.mockWebServerListener = mockWebServerListener;
        this.mockWebSocketListener = mockWebSocketListener;
        this.scheduler = scheduler;
        this.steps = steps;
    }
}

