/*
 * Decompiled with CFR 0.152.
 */
package com.trickl.flux.websocket;

import com.trickl.flux.websocket.WebSocketStepType;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public final class MockWebSocketListener
extends WebSocketListener {
    private static final Logger log = Logger.getLogger(MockWebSocketListener.class.getName());
    protected Queue<String> messages = new ConcurrentLinkedDeque<String>();
    protected Throwable failure = null;
    protected Queue<WebSocketStepType> steps = new ConcurrentLinkedDeque<WebSocketStepType>();
    protected WebSocket webSocket = null;
    private Object syncEvent = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket webSocket, Response response) {
        Object object = this.syncEvent;
        synchronized (object) {
            log.info("OPEN");
            this.steps.add(WebSocketStepType.OPEN);
            this.webSocket = webSocket;
            this.syncEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(WebSocket webSocket, String text) {
        Object object = this.syncEvent;
        synchronized (object) {
            log.info("Server received: " + text);
            this.messages.add(text);
            this.steps.add(WebSocketStepType.MESSAGE);
            this.syncEvent.notifyAll();
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onMessage(webSocket, bytes.utf8());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosing(WebSocket webSocket, int code, String reason) {
        Object object = this.syncEvent;
        synchronized (object) {
            log.info("CLOSING: " + code + " " + reason);
            this.steps.add(WebSocketStepType.CLOSING);
            this.syncEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(WebSocket webSocket, int code, String reason) {
        Object object = this.syncEvent;
        synchronized (object) {
            log.info("CLOSED: " + code + " " + reason);
            this.steps.add(WebSocketStepType.CLOSE);
            this.webSocket = null;
            this.syncEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable throwable, Response response) {
        Object object = this.syncEvent;
        synchronized (object) {
            log.log(Level.WARNING, "WebSocket Failure", throwable);
            this.failure = throwable;
            this.steps.add(WebSocketStepType.FAILURE);
            this.syncEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebSocketStepType nextStep(Duration timeout) {
        Instant start = Instant.now();
        Instant timeoutTime = start.plus(timeout);
        while (this.steps.isEmpty() && Instant.now().isBefore(timeoutTime)) {
            Object object = this.syncEvent;
            synchronized (object) {
                try {
                    this.syncEvent.wait(Math.max(Duration.between(Instant.now(), timeoutTime).toMillis(), 0L));
                }
                catch (InterruptedException ex) {
                    log.info("Wait Interrupted");
                    Thread.currentThread().interrupt();
                }
            }
        }
        return Optional.ofNullable(this.steps.poll()).orElse(WebSocketStepType.NOTHING);
    }

    public Queue<String> getMessages() {
        return this.messages;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public Queue<WebSocketStepType> getSteps() {
        return this.steps;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public Object getSyncEvent() {
        return this.syncEvent;
    }
}

