/*
 * Decompiled with CFR 0.152.
 */
package com.trickl.flux.websocket;

import com.trickl.flux.websocket.ServerListener;
import com.trickl.flux.websocket.WebServerStepType;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Logger;
import okhttp3.mockwebserver.MockWebServer;

public final class MockWebServerListener
implements ServerListener {
    private static final Logger log = Logger.getLogger(MockWebServerListener.class.getName());
    protected Queue<WebServerStepType> steps = new ConcurrentLinkedDeque<WebServerStepType>();
    protected MockWebServer server = null;
    private Object syncEvent = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart(MockWebServer server) {
        Object object = this.syncEvent;
        synchronized (object) {
            log.info("SERVER START");
            this.steps.add(WebServerStepType.SERVER_START);
            this.server = server;
            this.syncEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown() {
        Object object = this.syncEvent;
        synchronized (object) {
            log.info("SERVER SHUTDOWN");
            this.steps.add(WebServerStepType.SERVER_SHUTDOWN);
            this.server = null;
            this.syncEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebServerStepType nextStep(Duration timeout) {
        Object object = this.syncEvent;
        synchronized (object) {
            Instant start = Instant.now();
            Instant timeoutTime = start.plus(timeout);
            while (this.steps.isEmpty() && Instant.now().isBefore(timeoutTime)) {
                try {
                    this.syncEvent.wait(Math.max(Duration.between(Instant.now(), timeoutTime).toMillis(), 0L));
                }
                catch (InterruptedException ex) {
                    log.info("Wait Interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            return Optional.ofNullable(this.steps.poll()).orElse(WebServerStepType.NOTHING);
        }
    }

    public Queue<WebServerStepType> getSteps() {
        return this.steps;
    }

    public MockWebServer getServer() {
        return this.server;
    }

    public Object getSyncEvent() {
        return this.syncEvent;
    }
}

