/*
 * Decompiled with CFR 0.152.
 */
package com.trickl.flux.websocket;

import com.trickl.flux.websocket.ClosedWebSocketStepsBuilder;
import com.trickl.flux.websocket.MockWebServerListener;
import com.trickl.flux.websocket.MockWebSocketListener;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.mockwebserver.MockWebServer;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class MockServerWithWebSocket {
    private static final Logger log = Logger.getLogger(MockServerWithWebSocket.class.getName());
    private MockWebServer mockServer;
    MockWebServerListener serverListener = new MockWebServerListener();
    MockWebSocketListener webSocketListener = new MockWebSocketListener();
    private final Duration waitStartTimeout = Duration.ofSeconds(10L);
    Semaphore canStartSemaphore = new Semaphore(1);

    public ClosedWebSocketStepsBuilder beginVerifier() {
        Scheduler scheduler = Schedulers.newParallel((String)"verifier");
        ConcurrentLinkedQueue<Runnable> steps = new ConcurrentLinkedQueue<Runnable>();
        return new ClosedWebSocketStepsBuilder(() -> this.mockServer, this.serverListener, this.webSocketListener, scheduler, steps);
    }

    public void start() {
        try {
            if (!this.canStartSemaphore.tryAcquire(this.waitStartTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                String warning = MessageFormat.format("Timeout of {0} elapsed waiting for shutdown, attempting to start anyway.", this.waitStartTimeout);
                log.log(Level.WARNING, warning);
            }
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Interruped wait on shutdown");
            Thread.currentThread().interrupt();
        }
        this.mockServer = new MockWebServer();
        try {
            this.mockServer.start();
            this.serverListener.onStart(this.mockServer);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Unable to start server", ex);
        }
    }

    public void shutdown() throws IOException {
        this.mockServer.shutdown();
        this.serverListener.onShutdown();
        this.canStartSemaphore.release();
    }

    public URI getWebSocketUri() {
        return this.mockServer.url("/websocket").uri();
    }
}

