/*
 * Decompiled with CFR 0.152.
 */
package com.trickl.flux.websocket;

import com.trickl.exceptions.StepVerifierException;
import com.trickl.flux.websocket.MockWebServerListener;
import com.trickl.flux.websocket.MockWebSocketListener;
import com.trickl.flux.websocket.OpenWebSocketStepsBuilder;
import com.trickl.flux.websocket.VerifierComplete;
import com.trickl.flux.websocket.WebServerStepType;
import com.trickl.flux.websocket.WebSocketStepType;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import java.util.logging.Logger;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import reactor.core.scheduler.Scheduler;

public final class ClosedWebSocketStepsBuilder {
    private static final Logger log = Logger.getLogger(ClosedWebSocketStepsBuilder.class.getName());
    private final Supplier<MockWebServer> serverSupplier;
    private final MockWebServerListener mockWebServerListener;
    private final MockWebSocketListener mockWebSocketListener;
    private final Scheduler scheduler;
    private final Queue<Runnable> steps;

    public ClosedWebSocketStepsBuilder thenWaitServerShutdown() {
        return this.thenWaitServerShutdown(Duration.ofSeconds(10L));
    }

    public ClosedWebSocketStepsBuilder thenWaitServerShutdown(Duration timeout) {
        this.steps.add(() -> this.testWasShutdown(timeout));
        return this;
    }

    protected void testWasShutdown(Duration timeout) {
        log.info("Waiting on SERVER_SHUTDOWN");
        WebServerStepType nextStep = this.mockWebServerListener.nextStep(timeout);
        if (!nextStep.equals((Object)WebServerStepType.SERVER_SHUTDOWN)) {
            throw new StepVerifierException("Expected SERVER_SHUTDOWN got - " + (Object)((Object)nextStep));
        }
    }

    public ClosedWebSocketStepsBuilder thenWaitServerStartThenUpgrade() {
        return this.thenWaitServerStartThenUpgrade(Duration.ofSeconds(10L));
    }

    public ClosedWebSocketStepsBuilder thenWaitServerStartThenUpgrade(Duration timeout) {
        this.steps.add(() -> {
            this.testWasStarted(timeout);
            MockResponse response = new MockResponse().withWebSocketUpgrade((WebSocketListener)this.mockWebSocketListener);
            this.serverSupplier.get().enqueue(response);
        });
        return this;
    }

    protected void testWasStarted(Duration timeout) {
        log.info("Waiting on SERVER_START");
        WebServerStepType nextStep = this.mockWebServerListener.nextStep(timeout);
        if (!nextStep.equals((Object)WebServerStepType.SERVER_START)) {
            throw new StepVerifierException("Expected SERVER_START got - " + (Object)((Object)nextStep));
        }
    }

    public OpenWebSocketStepsBuilder thenExpectOpen() {
        return this.thenExpectOpen(Duration.ofSeconds(10L));
    }

    public OpenWebSocketStepsBuilder thenExpectOpen(Duration timeout) {
        this.steps.add(() -> this.testWasOpen(timeout));
        return new OpenWebSocketStepsBuilder(this.serverSupplier, this.mockWebServerListener, this.mockWebSocketListener, this.scheduler, this.steps);
    }

    protected void testWasOpen(Duration timeout) {
        log.info("Waiting on OPEN");
        WebSocketStepType nextStep = this.mockWebSocketListener.nextStep(timeout);
        if (!nextStep.equals((Object)WebSocketStepType.OPEN)) {
            throw new StepVerifierException("Expected OPEN got - " + (Object)((Object)nextStep));
        }
    }

    public ClosedWebSocketStepsBuilder then(Runnable step) {
        this.steps.add(step);
        return this;
    }

    public VerifierComplete thenVerify() {
        CountDownLatch completeSignal = new CountDownLatch(1);
        this.scheduler.schedule(() -> {
            while (!this.steps.isEmpty()) {
                this.steps.remove().run();
            }
            completeSignal.countDown();
        });
        return new VerifierComplete(completeSignal);
    }

    public ClosedWebSocketStepsBuilder(Supplier<MockWebServer> serverSupplier, MockWebServerListener mockWebServerListener, MockWebSocketListener mockWebSocketListener, Scheduler scheduler, Queue<Runnable> steps) {
        this.serverSupplier = serverSupplier;
        this.mockWebServerListener = mockWebServerListener;
        this.mockWebSocketListener = mockWebSocketListener;
        this.scheduler = scheduler;
        this.steps = steps;
    }
}

