/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;
import java.net.URI;

public class URIEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<URI, Number> {
    private static final long serialVersionUID = -5184680687177329611L;

    public URIEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.URI, URI.class, EnumKeyValueConfigurationDataType.NUMBER);
    }

    @Override
    public URI validateValue(EnumKeyValueConfigurationSizing<Number> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        URI inputURI = (URI)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<Number> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputURI;
        }
        if (inputURI == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputURI;
            }
            throw new EmptyValueException("Empty value: invalid timestamp, should be at least [" + valueSize.getMinSizeAsString() + "]!");
        }
        return inputURI;
    }

    @Override
    public EnumKeyValueConfigurationSizing<Number> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<Number>();
    }

    @Override
    public Long getMinSize() {
        return 3L;
    }

    @Override
    public Long getMaxSize() {
        return Long.MAX_VALUE;
    }

    @Override
    protected boolean isGreaterThan(Number first, Number second) {
        return this.isGreaterThanValue(first, second);
    }
}

