/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.enumeration.configuration.validation.value.impl;

import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationDataType;
import com.github.toolarium.enumeration.configuration.dto.EnumKeyValueConfigurationSizing;
import com.github.toolarium.enumeration.configuration.util.DateUtil;
import com.github.toolarium.enumeration.configuration.validation.EmptyValueException;
import com.github.toolarium.enumeration.configuration.validation.ValidationException;
import com.github.toolarium.enumeration.configuration.validation.value.impl.AbstractEnumKeyValueConfigurationValueValidator;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class TimestampEnumKeyValueConfigurationValueValidator
extends AbstractEnumKeyValueConfigurationValueValidator<Instant, Instant> {
    private static final long serialVersionUID = 2922787805935547890L;

    public TimestampEnumKeyValueConfigurationValueValidator() {
        super(EnumKeyValueConfigurationDataType.TIMESTAMP, Instant.class, EnumKeyValueConfigurationDataType.TIMESTAMP);
    }

    @Override
    public Instant validateValue(EnumKeyValueConfigurationSizing<Instant> valueSize, String inputValue) throws EmptyValueException, ValidationException {
        Instant inputTimestamp = (Instant)this.parseValue(inputValue);
        AbstractEnumKeyValueConfigurationValueValidator.MinMaxValue<Instant> minMaxValue = this.preapreMinMaxValue(valueSize, inputValue);
        if (minMaxValue == null) {
            return inputTimestamp;
        }
        if (inputTimestamp == null) {
            if (minMaxValue.getMin() == null || minMaxValue.getMin().equals(this.getMinSize())) {
                return inputTimestamp;
            }
            throw new EmptyValueException("Empty value: invalid timestamp, should be at least [" + valueSize.getMinSizeAsString() + "]!");
        }
        if ((inputTimestamp = inputTimestamp.truncatedTo(ChronoUnit.MILLIS)).compareTo(minMaxValue.getMin()) < 0) {
            throw new ValidationException("Too small: invalid timestamp of [" + inputValue + "], should be at least [" + valueSize.getMinSizeAsString() + "] (now " + inputValue + ")!", inputValue, inputTimestamp);
        }
        if (inputTimestamp.compareTo(minMaxValue.getMax()) > 0) {
            throw new ValidationException("Too big: invalid timestamp of [" + inputValue + "], should be in range of [" + valueSize.getMinSizeAsString() + ".." + valueSize.getMaxSizeAsString() + "] (now " + inputValue + ")!", inputValue, inputTimestamp);
        }
        return inputTimestamp;
    }

    @Override
    public EnumKeyValueConfigurationSizing<Instant> createEnumKeyValueConfigurationSizing() {
        return new EnumKeyValueConfigurationSizing<Instant>();
    }

    @Override
    public Instant getMinSize() {
        return Instant.MIN;
    }

    @Override
    public Instant getMaxSize() {
        return DateUtil.MAX_TIMESTAMP;
    }

    @Override
    protected boolean isGreaterThan(Instant first, Instant second) {
        if (first == null) {
            return second != null;
        }
        if (second == null) {
            return false;
        }
        return first.isAfter(second);
    }
}

